/*
 * Decompiled with CFR 0.152.
 */
package com.github.dozermapper.spring;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dozer.BeanFactory;
import org.dozer.CustomConverter;
import org.dozer.CustomFieldMapper;
import org.dozer.DozerBeanMapperBuilder;
import org.dozer.DozerEventListener;
import org.dozer.Mapper;
import org.dozer.loader.api.BeanMappingBuilder;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.Resource;

public class DozerBeanMapperFactoryBean
implements ApplicationContextAware,
InitializingBean,
FactoryBean<Mapper> {
    private ApplicationContext applicationContext;
    private CustomFieldMapper customFieldMapper;
    private List<String> mappingFileUrls = new ArrayList<String>(1);
    private List<CustomConverter> customConverters = new ArrayList<CustomConverter>(0);
    private List<BeanMappingBuilder> mappingBuilders = new ArrayList<BeanMappingBuilder>(0);
    private List<DozerEventListener> eventListeners = new ArrayList<DozerEventListener>(0);
    private Map<String, BeanFactory> beanFactories = new HashMap<String, BeanFactory>(0);
    private Map<String, CustomConverter> customConvertersWithId = new HashMap<String, CustomConverter>(0);
    private Mapper mapper;

    public void setCustomFieldMapper(CustomFieldMapper customFieldMapper) {
        this.customFieldMapper = customFieldMapper;
    }

    public void setMappingFiles(Resource[] mappingFiles) throws IOException {
        if (mappingFiles != null && mappingFiles.length > 0) {
            for (Resource mappingFile : mappingFiles) {
                URL url = mappingFile.getURL();
                this.mappingFileUrls.add(url.toString());
            }
        }
    }

    public void setCustomConverters(List<CustomConverter> customConverters) {
        this.customConverters.addAll(customConverters);
    }

    public void setMappingBuilders(List<BeanMappingBuilder> mappingBuilders) {
        this.mappingBuilders.addAll(mappingBuilders);
    }

    public void setEventListeners(List<DozerEventListener> eventListeners) {
        this.eventListeners.addAll(eventListeners);
    }

    public void setFactories(Map<String, BeanFactory> beanFactories) {
        this.beanFactories.putAll(beanFactories);
    }

    public void setCustomConvertersWithId(Map<String, CustomConverter> customConvertersWithId) {
        this.customConvertersWithId.putAll(customConvertersWithId);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void afterPropertiesSet() throws Exception {
        Map contextCustomConvertersWithId = this.applicationContext.getBeansOfType(CustomConverter.class);
        Map contextBeanMappingBuilders = this.applicationContext.getBeansOfType(BeanMappingBuilder.class);
        Map contextEventListeners = this.applicationContext.getBeansOfType(DozerEventListener.class);
        Map contextBeanFactorys = this.applicationContext.getBeansOfType(BeanFactory.class);
        this.customConverters.addAll(contextCustomConvertersWithId.values());
        this.mappingBuilders.addAll(contextBeanMappingBuilders.values());
        this.beanFactories.putAll(contextBeanFactorys);
        this.eventListeners.addAll(contextEventListeners.values());
        this.customConvertersWithId.putAll(contextCustomConvertersWithId);
        this.mapper = DozerBeanMapperBuilder.create().withMappingFiles(this.mappingFileUrls).withCustomFieldMapper(this.customFieldMapper).withCustomConverters(this.customConverters).withMappingBuilders(this.mappingBuilders).withEventListeners(this.eventListeners).withBeanFactorys(this.beanFactories).withCustomConvertersWithIds(this.customConvertersWithId).build();
    }

    public Mapper getObject() throws Exception {
        return this.mapper;
    }

    public Class<Mapper> getObjectType() {
        return Mapper.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

