/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.jaxrs;

import com.github.dockerjava.api.exception.DockerClientException;
import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.jaxrs.UnixConnectionSocketFactory;
import com.github.dockerjava.jaxrs.filter.ResponseStatusExceptionFilter;
import com.github.dockerjava.jaxrs.filter.SelectiveLoggingFilter;
import com.github.dockerjava.transport.DockerHttpClient;
import com.github.dockerjava.transport.SSLConfig;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.net.ssl.SSLContext;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.impl.io.EmptyInputStream;
import org.glassfish.jersey.apache.connector.ApacheConnectorProvider;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.RequestEntityProcessing;
import org.glassfish.jersey.client.spi.ConnectorProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JerseyDockerHttpClient
implements DockerHttpClient {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)JerseyDockerHttpClient.class.getName());
    private final Client client;
    private final PoolingHttpClientConnectionManager connManager;
    private final URI originalUri;

    /*
     * WARNING - void declaration
     */
    private JerseyDockerHttpClient(URI dockerHost, SSLConfig sslConfig, Integer maxTotalConnections, Integer maxPerRouteConnections, Integer connectionRequestTimeout, Integer readTimeout, Integer connectTimeout, ClientRequestFilter[] clientRequestFilters, ClientResponseFilter[] clientResponseFilters, RequestEntityProcessing requestEntityProcessing) {
        void var16_25;
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.connectorProvider((ConnectorProvider)new ApacheConnectorProvider());
        clientConfig.property("jersey.config.disableAutoDiscovery", (Object)true);
        if (requestEntityProcessing != null) {
            clientConfig.property("jersey.config.client.request.entity.processing", (Object)requestEntityProcessing);
        }
        clientConfig.register((Object)new ResponseStatusExceptionFilter());
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
        clientConfig.register((Object)new SelectiveLoggingFilter(LOGGER, true));
        if (readTimeout != null) {
            requestConfigBuilder.setSocketTimeout(readTimeout.intValue());
            clientConfig.property("jersey.config.client.readTimeout", (Object)readTimeout);
        }
        if (connectTimeout != null) {
            requestConfigBuilder.setConnectTimeout(connectTimeout.intValue());
            clientConfig.property("jersey.config.client.connectTimeout", (Object)connectTimeout);
        }
        if (clientResponseFilters != null) {
            for (ClientResponseFilter clientResponseFilter : clientResponseFilters) {
                if (clientResponseFilter == null) continue;
                clientConfig.register((Object)clientResponseFilter);
            }
        }
        if (clientRequestFilters != null) {
            for (ClientResponseFilter clientResponseFilter : clientRequestFilters) {
                if (clientResponseFilter == null) continue;
                clientConfig.register((Object)clientResponseFilter);
            }
        }
        SSLContext sslContext = null;
        try {
            if (sslConfig != null) {
                sslContext = sslConfig.getSSLContext();
            }
        }
        catch (Exception ex) {
            throw new DockerClientException("Error in SSL Configuration", (Throwable)ex);
        }
        String protocol = sslContext != null ? "https" : "http";
        String string = dockerHost.getScheme();
        int n = -1;
        switch (string.hashCode()) {
            case 3594632: {
                if (!string.equals("unix")) break;
                boolean bl = false;
                break;
            }
            case 114657: {
                if (!string.equals("tcp")) break;
                boolean bl = true;
            }
        }
        switch (var16_25) {
            case 0: {
                break;
            }
            case 1: {
                try {
                    dockerHost = new URI(dockerHost.toString().replaceFirst("tcp", protocol));
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e);
                }
                this.configureProxy(clientConfig, dockerHost, protocol);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported protocol scheme: " + dockerHost);
            }
        }
        this.connManager = new PoolingHttpClientConnectionManager(this.getSchemeRegistry(dockerHost, sslContext)){

            public void close() {
                super.shutdown();
            }

            public void shutdown() {
            }
        };
        if (maxTotalConnections != null) {
            this.connManager.setMaxTotal(maxTotalConnections.intValue());
        }
        if (maxPerRouteConnections != null) {
            this.connManager.setDefaultMaxPerRoute(maxPerRouteConnections.intValue());
        }
        clientConfig.property("jersey.config.apache.client.connectionManager", (Object)this.connManager);
        if (connectionRequestTimeout != null) {
            requestConfigBuilder.setConnectionRequestTimeout(connectionRequestTimeout.intValue());
        }
        clientConfig.property("jersey.config.apache.client.requestConfig", (Object)requestConfigBuilder.build());
        ClientBuilder clientBuilder = ClientBuilder.newBuilder().withConfig((Configuration)clientConfig);
        if (sslContext != null) {
            clientBuilder.sslContext(sslContext);
        }
        this.client = clientBuilder.build();
        this.originalUri = dockerHost;
    }

    private URI sanitizeUrl(URI originalUri) {
        if (originalUri.getScheme().equals("unix")) {
            return UnixConnectionSocketFactory.sanitizeUri(originalUri);
        }
        return originalUri;
    }

    private Registry<ConnectionSocketFactory> getSchemeRegistry(URI originalUri, SSLContext sslContext) {
        RegistryBuilder registryBuilder = RegistryBuilder.create();
        registryBuilder.register("http", (Object)PlainConnectionSocketFactory.getSocketFactory());
        if (sslContext != null) {
            registryBuilder.register("https", (Object)new SSLConnectionSocketFactory(sslContext));
        }
        registryBuilder.register("unix", (Object)new UnixConnectionSocketFactory(originalUri));
        return registryBuilder.build();
    }

    public DockerHttpClient.Response execute(DockerHttpClient.Request request) {
        if (request.hijackedInput() != null) {
            throw new UnsupportedOperationException("Does not support hijacking");
        }
        String url = this.sanitizeUrl(this.originalUri).toString();
        if (url.endsWith("/") && request.path().startsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        Invocation.Builder builder = this.client.target(url + request.path()).request();
        request.headers().forEach((arg_0, arg_1) -> ((Invocation.Builder)builder).header(arg_0, arg_1));
        try {
            return new JerseyResponse(builder.build(request.method(), this.toEntity(request)).invoke());
        }
        catch (ProcessingException e) {
            if (e.getCause() instanceof DockerException) {
                throw (DockerException)e.getCause();
            }
            throw e;
        }
    }

    private Entity<InputStream> toEntity(DockerHttpClient.Request request) {
        InputStream body = request.body();
        if (body != null) {
            return Entity.entity((Object)body, (MediaType)MediaType.APPLICATION_JSON_TYPE);
        }
        switch (request.method()) {
            case "POST": {
                return Entity.json(null);
            }
        }
        return null;
    }

    private void configureProxy(ClientConfig clientConfig, URI originalUri, String protocol) {
        List<Proxy> proxies = ProxySelector.getDefault().select(originalUri);
        for (Proxy proxy : proxies) {
            InetSocketAddress address = (InetSocketAddress)proxy.address();
            if (address == null) continue;
            String hostname = address.getHostName();
            int port = address.getPort();
            clientConfig.property("jersey.config.client.proxy.uri", (Object)("http://" + hostname + ":" + port));
            String httpProxyUser = System.getProperty(protocol + ".proxyUser");
            if (httpProxyUser == null) continue;
            clientConfig.property("jersey.config.client.proxy.username", (Object)httpProxyUser);
            String httpProxyPassword = System.getProperty(protocol + ".proxyPassword");
            if (httpProxyPassword == null) continue;
            clientConfig.property("jersey.config.client.proxy.password", (Object)httpProxyPassword);
        }
    }

    public void close() {
        if (this.client != null) {
            this.client.close();
        }
        if (this.connManager != null) {
            this.connManager.close();
        }
    }

    private static class JerseyResponse
    implements DockerHttpClient.Response {
        private final Response response;

        JerseyResponse(Response response) {
            this.response = response;
        }

        public int getStatusCode() {
            return this.response.getStatus();
        }

        public Map<String, List<String>> getHeaders() {
            return this.response.getStringHeaders();
        }

        public InputStream getBody() {
            return this.response.hasEntity() ? (InputStream)this.response.readEntity(InputStream.class) : EmptyInputStream.INSTANCE;
        }

        public void close() {
            this.response.close();
        }
    }

    public static final class Builder {
        private URI dockerHost = null;
        private SSLConfig sslConfig = null;
        private Integer readTimeout = null;
        private Integer connectTimeout = null;
        private Integer maxTotalConnections = null;
        private Integer maxPerRouteConnections = null;
        private Integer connectionRequestTimeout = null;
        private ClientRequestFilter[] clientRequestFilters = null;
        private ClientResponseFilter[] clientResponseFilters = null;
        private RequestEntityProcessing requestEntityProcessing;

        public Builder dockerHost(URI value) {
            this.dockerHost = Objects.requireNonNull(value, "dockerHost");
            return this;
        }

        public Builder sslConfig(SSLConfig value) {
            this.sslConfig = value;
            return this;
        }

        public Builder readTimeout(Integer value) {
            this.readTimeout = value;
            return this;
        }

        public Builder connectTimeout(Integer value) {
            this.connectTimeout = value;
            return this;
        }

        public Builder maxTotalConnections(Integer value) {
            this.maxTotalConnections = value;
            return this;
        }

        public Builder maxPerRouteConnections(Integer value) {
            this.maxPerRouteConnections = value;
            return this;
        }

        public Builder connectionRequestTimeout(Integer value) {
            this.connectionRequestTimeout = value;
            return this;
        }

        public Builder clientResponseFilters(ClientResponseFilter[] value) {
            this.clientResponseFilters = value;
            return this;
        }

        public Builder clientRequestFilters(ClientRequestFilter[] value) {
            this.clientRequestFilters = value;
            return this;
        }

        public Builder requestEntityProcessing(RequestEntityProcessing value) {
            this.requestEntityProcessing = value;
            return this;
        }

        public JerseyDockerHttpClient build() {
            return new JerseyDockerHttpClient(this.dockerHost, this.sslConfig, this.maxTotalConnections, this.maxPerRouteConnections, this.connectionRequestTimeout, this.readTimeout, this.connectTimeout, this.clientRequestFilters, this.clientResponseFilters, this.requestEntityProcessing);
        }
    }
}

