/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidfantasy.mybatisplus.generatorui.service;

import cn.hutool.core.io.FileUtil;
import com.github.davidfantasy.mybatisplus.generatorui.ProjectPathResolver;
import com.github.davidfantasy.mybatisplus.generatorui.common.ServiceException;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AutoCompleteService {
    @Autowired
    private ProjectPathResolver projectPathResolver;

    public Set<String> searchXmlMapperName(String mapperLocationPrefix, String searchKey) {
        String mapperRootPath = "";
        if ("resources:".startsWith(mapperLocationPrefix)) {
            mapperRootPath = this.projectPathResolver.getResourcePath();
        } else if ("java:".startsWith(mapperLocationPrefix)) {
            mapperRootPath = this.projectPathResolver.getSourcePath();
        } else {
            throw new ServiceException("\u65e0\u6cd5\u8bc6\u522b\u7684\u6e90\u7801\u524d\u7f00\uff1a" + mapperLocationPrefix);
        }
        HashSet hitNames = Sets.newHashSet();
        this.doSearch(new File(mapperRootPath), ".xml", searchKey, hitNames);
        return hitNames;
    }

    private void doSearch(File rootDir, String searchKey, String suffix, Set<String> hitNames) {
        File[] files;
        if (!FileUtil.exist((File)rootDir)) {
            return;
        }
        if (!FileUtil.isDirectory((File)rootDir)) {
            return;
        }
        for (File file : files = FileUtil.ls((String)rootDir.getAbsolutePath())) {
            if (!file.isDirectory()) {
                String filePackageName = this.projectPathResolver.convertPathToPackage(file.getAbsolutePath());
                if (!this.match(filePackageName, searchKey, suffix)) continue;
                hitNames.add(filePackageName.substring(0, filePackageName.length() - suffix.length()));
                continue;
            }
            this.doSearch(file, suffix, searchKey, hitNames);
        }
    }

    private boolean match(String name, String searchKey, String suffix) {
        if (!name.endsWith(suffix)) {
            return false;
        }
        if (Strings.isNullOrEmpty((String)name)) {
            return true;
        }
        return name.toLowerCase().indexOf(searchKey.toLowerCase()) != -1;
    }
}

