/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidfantasy.mybatisplus.generatorui.controller;

import com.github.davidfantasy.mybatisplus.generatorui.ProjectPathResolver;
import com.github.davidfantasy.mybatisplus.generatorui.common.Result;
import com.github.davidfantasy.mybatisplus.generatorui.common.ResultGenerator;
import com.github.davidfantasy.mybatisplus.generatorui.dto.OutputFileInfo;
import com.github.davidfantasy.mybatisplus.generatorui.service.OutputFileInfoService;
import com.github.davidfantasy.mybatisplus.generatorui.service.UserConfigStore;
import com.github.davidfantasy.mybatisplus.generatorui.strategy.ControllerStrategy;
import com.github.davidfantasy.mybatisplus.generatorui.strategy.EntityStrategy;
import com.github.davidfantasy.mybatisplus.generatorui.strategy.MapperStrategy;
import com.github.davidfantasy.mybatisplus.generatorui.strategy.MapperXmlStrategy;
import com.github.davidfantasy.mybatisplus.generatorui.strategy.ServiceImplStrategy;
import com.github.davidfantasy.mybatisplus.generatorui.strategy.ServiceStrategy;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/output-file-info"})
public class OutputFileInfoController {
    @Autowired
    private OutputFileInfoService outputFileInfoService;
    @Autowired
    private UserConfigStore userConfigStore;
    @Autowired
    private ProjectPathResolver projectPathResolver;

    @GetMapping(value={"/user-config"})
    public Result getUserConfig() {
        return ResultGenerator.genSuccessResult(this.userConfigStore.getDefaultUserConfig());
    }

    @GetMapping(value={"/project-root-path"})
    public Result getRootPath() {
        return ResultGenerator.genSuccessResult(this.projectPathResolver.getBaseProjectPath());
    }

    @PostMapping(value={"/delete"})
    public Result deleteOutputInfos(@RequestBody OutputFileInfo outputFileInfo) throws IOException {
        this.outputFileInfoService.deleteOutputFileInfo(outputFileInfo);
        return ResultGenerator.genSuccessResult();
    }

    @PostMapping(value={"/save"})
    public Result saveOutputInfos(@RequestBody OutputFileInfo outputFileInfo) throws IOException {
        this.outputFileInfoService.saveOutputFileInfo(outputFileInfo);
        return ResultGenerator.genSuccessResult();
    }

    @PostMapping(value={"/save-entity-strategy"})
    public Result saveEntityStrategy(@RequestBody EntityStrategy entityStrategy) throws IOException {
        this.outputFileInfoService.saveEntityStrategy(entityStrategy);
        return ResultGenerator.genSuccessResult();
    }

    @PostMapping(value={"/save-mapper-strategy"})
    public Result saveMapperStrategy(@RequestBody MapperStrategy mapperStrategy) throws IOException {
        this.outputFileInfoService.saveMapperStrategy(mapperStrategy);
        return ResultGenerator.genSuccessResult();
    }

    @PostMapping(value={"/save-mapper-xml-strategy"})
    public Result saveMapperXmlStrategy(@RequestBody MapperXmlStrategy mapperXmlStrategy) throws IOException {
        this.outputFileInfoService.saveMapperXmlStrategy(mapperXmlStrategy);
        return ResultGenerator.genSuccessResult();
    }

    @PostMapping(value={"/save-controller-strategy"})
    public Result saveControllerStrategy(@RequestBody ControllerStrategy controllerStrategy) throws IOException {
        this.outputFileInfoService.saveControllerStrategy(controllerStrategy);
        return ResultGenerator.genSuccessResult();
    }

    @PostMapping(value={"/save-service-strategy"})
    public Result saveServiceStrategy(@RequestBody ServiceStrategy serviceStrategy) throws IOException {
        this.outputFileInfoService.saveServiceStrategy(serviceStrategy);
        return ResultGenerator.genSuccessResult();
    }

    @PostMapping(value={"/save-service-impl-strategy"})
    public Result saveServiceImplStrategy(@RequestBody ServiceImplStrategy ServiceImplStrategy2) throws IOException {
        this.outputFileInfoService.saveServiceImplStrategy(ServiceImplStrategy2);
        return ResultGenerator.genSuccessResult();
    }

    @GetMapping(value={"/check-if-new-project"})
    public Result checkIfNewProject() {
        return ResultGenerator.genSuccessResult(!this.userConfigStore.checkUserConfigExisted());
    }

    @GetMapping(value={"/all-saved-project"})
    public Result getAllSavedProject() {
        return ResultGenerator.genSuccessResult(this.userConfigStore.getAllSavedProject());
    }

    @PostMapping(value={"/import-project-config/{sourceProjectPkg}"})
    public Result importProjectConfig(@PathVariable(value="sourceProjectPkg") String sourceProjectPkg) throws IOException {
        this.userConfigStore.importProjectConfig(sourceProjectPkg);
        return ResultGenerator.genSuccessResult();
    }
}

