/*
 * Decompiled with CFR 0.152.
 */
package cn.beecp.pool;

import cn.beecp.pool.ProxyStatementBase;

final class StatementArray {
    private int pos;
    private ProxyStatementBase[] elements;

    public StatementArray(int initSize) {
        this.elements = new ProxyStatementBase[initSize];
    }

    public final int size() {
        return this.pos;
    }

    public final void add(ProxyStatementBase e) {
        if (this.pos == this.elements.length) {
            ProxyStatementBase[] newArray = new ProxyStatementBase[this.elements.length << 1];
            System.arraycopy(this.elements, 0, newArray, 0, this.elements.length);
            this.elements = newArray;
        }
        this.elements[this.pos++] = e;
    }

    public final void remove(ProxyStatementBase e) {
        for (int i = 0; i < this.pos; ++i) {
            if (e != this.elements[i]) continue;
            int m = this.pos - i - 1;
            if (m > 0) {
                System.arraycopy(this.elements, i + 1, this.elements, i, m);
            }
            this.elements[--this.pos] = null;
            return;
        }
    }

    public final void clear() {
        if (this.pos > 0) {
            for (int i = 0; i < this.pos; ++i) {
                if (this.elements[i] == null) continue;
                this.elements[i].setAsClosed();
                this.elements[i] = null;
            }
            this.pos = 0;
        }
    }
}

