/*
 * Decompiled with CFR 0.152.
 */
package cn.beecp.pool;

import cn.beecp.pool.PoolStaticCenter;
import cn.beecp.pool.PooledConnection;
import cn.beecp.pool.ProxyConnectionBase;
import cn.beecp.pool.ProxyResultSetBase;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

abstract class ProxyStatementBase
implements Statement {
    protected Statement delegate;
    protected PooledConnection pConn;
    private ProxyResultSetBase curRe;
    private boolean registered = true;
    private boolean isClosed;
    private int resultOpenCode = 1;
    private ArrayList<ProxyResultSetBase> results;
    private ProxyConnectionBase proxyConn;

    public ProxyStatementBase(Statement delegate, PooledConnection pConn) {
        this.delegate = delegate;
        this.pConn = pConn;
        this.proxyConn = pConn.proxyConn;
        this.proxyConn.registerStatement(this);
    }

    private final void checkClosed() throws SQLException {
        if (this.isClosed) {
            throw PoolStaticCenter.StatementClosedException;
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.checkClosed();
        return this.proxyConn;
    }

    @Override
    public final boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public final void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        if (this.curRe != null && !this.curRe.isClosed) {
            this.curRe.setAsClosed();
        }
        if (this.results != null) {
            int l = this.results.size();
            for (int i = 0; i < l; ++i) {
                this.results.get(i).setAsClosed();
            }
            this.results.clear();
        }
        if (this.registered) {
            this.proxyConn.unregisterStatement(this);
        }
        try {
            this.delegate.close();
        }
        finally {
            this.delegate = PoolStaticCenter.CLOSED_CSTM;
        }
    }

    void setAsClosed() {
        try {
            this.registered = false;
            this.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    final void setOpenResultSet(ProxyResultSetBase resultSetNew) {
        switch (this.resultOpenCode) {
            case 1: {
                if (this.curRe == null || this.curRe.isClosed) break;
                this.curRe.setAsClosed();
                break;
            }
            case 2: {
                if (this.curRe == null || this.curRe.isClosed) break;
                if (this.results == null) {
                    this.results = new ArrayList(1);
                }
                this.results.add(this.curRe);
                break;
            }
            case 3: {
                if (this.curRe != null && !this.curRe.isClosed) {
                    this.curRe.setAsClosed();
                }
                if (this.results == null) break;
                int l = this.results.size();
                for (int i = 0; i < l; ++i) {
                    ProxyResultSetBase openRe = this.results.get(i);
                    if (openRe.isClosed) continue;
                    openRe.setAsClosed();
                }
                this.results.clear();
                break;
            }
        }
        this.curRe = resultSetNew;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.getMoreResults(1);
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        this.checkClosed();
        this.resultOpenCode = current;
        return this.delegate.getMoreResults(current);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.checkClosed();
        ResultSet re = this.delegate.getResultSet();
        if (re == null) {
            this.setOpenResultSet(null);
            return null;
        }
        if (this.curRe != null && this.curRe.isDelegate(re)) {
            return this.curRe;
        }
        return PoolStaticCenter.createProxyResultSet(re, this, this.pConn);
    }

    @Override
    public void setPoolable(boolean var1) throws SQLException {
        this.checkClosed();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance(this)) {
            return (T)this;
        }
        throw new SQLException("Wrapped object is not an instance of " + iface);
    }
}

