/*
 * Decompiled with CFR 0.152.
 */
package cn.beecp.pool;

import cn.beecp.pool.PoolStaticCenter;
import cn.beecp.pool.PooledConnection;
import cn.beecp.pool.ProxyStatementBase;
import cn.beecp.pool.StatementArray;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.Executor;

public abstract class ProxyConnectionBase
implements Connection {
    protected Connection delegate;
    protected PooledConnection pConn;
    private boolean isClosed;
    private StatementArray statements;

    public ProxyConnectionBase(PooledConnection pConn) {
        this.pConn = pConn;
        pConn.proxyConn = this;
        this.delegate = pConn.rawConn;
        this.statements = pConn.tracedStatements;
    }

    public Connection getDelegate() throws SQLException {
        this.checkClosed();
        return this.delegate;
    }

    @Override
    public final boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    protected final void checkClosed() throws SQLException {
        if (this.isClosed) {
            throw PoolStaticCenter.ConnectionClosedException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() throws SQLException {
        ProxyConnectionBase proxyConnectionBase = this;
        synchronized (proxyConnectionBase) {
            if (this.isClosed) {
                return;
            }
            this.isClosed = true;
            this.delegate = PoolStaticCenter.CLOSED_CON;
            this.statements.clear();
        }
        this.pConn.recycleSelf();
    }

    final void trySetAsClosed() {
        try {
            this.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    final synchronized void registerStatement(ProxyStatementBase st) {
        this.statements.add(st);
    }

    final synchronized void unregisterStatement(ProxyStatementBase st) {
        this.statements.remove(st);
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.checkClosed();
        if (!this.pConn.curAutoCommit && this.pConn.commitDirtyInd) {
            throw PoolStaticCenter.AutoCommitChangeForbiddenException;
        }
        this.delegate.setAutoCommit(autoCommit);
        this.pConn.curAutoCommit = autoCommit;
        if (autoCommit) {
            this.pConn.commitDirtyInd = false;
        }
        this.pConn.setResetInd(0, autoCommit != this.pConn.defaultAutoCommit);
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.delegate.setTransactionIsolation(level);
        this.pConn.setResetInd(1, level != this.pConn.defaultTransactionIsolationCode);
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.delegate.setReadOnly(readOnly);
        this.pConn.setResetInd(2, readOnly != this.pConn.defaultReadOnly);
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.delegate.setCatalog(catalog);
        this.pConn.setResetInd(3, !PoolStaticCenter.equals(catalog, this.pConn.defaultCatalog));
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return this.delegate.isValid(timeout);
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.delegate.setSchema(schema);
        this.pConn.setResetInd(4, !PoolStaticCenter.equals(schema, this.pConn.defaultSchema));
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        this.checkClosed();
        if (executor == null) {
            throw new SQLException("executor can't be null");
        }
        executor.execute(new Runnable(){

            @Override
            public void run() {
                ProxyConnectionBase.this.trySetAsClosed();
            }
        });
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return this.delegate.getNetworkTimeout();
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.checkClosed();
        if (!this.pConn.supportNetworkTimeout()) {
            throw PoolStaticCenter.DriverNotSupportNetworkTimeoutException;
        }
        this.delegate.setNetworkTimeout(executor, milliseconds);
        this.pConn.setResetInd(5, milliseconds != this.pConn.defaultNetworkTimeout);
    }

    @Override
    public void commit() throws SQLException {
        this.delegate.commit();
        this.pConn.lastAccessTime = System.currentTimeMillis();
        this.pConn.commitDirtyInd = false;
    }

    @Override
    public void rollback() throws SQLException {
        this.delegate.rollback();
        this.pConn.lastAccessTime = System.currentTimeMillis();
        this.pConn.commitDirtyInd = false;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance(this)) {
            return (T)this;
        }
        throw new SQLException("Wrapped object is not an instance of " + iface);
    }
}

