/*
 * Decompiled with CFR 0.152.
 */
package cn.beecp.pool;

import cn.beecp.ConnectionFactory;
import cn.beecp.pool.PoolStaticCenter;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;

public class DataSourceConnectionFactory
implements ConnectionFactory {
    private String username;
    private String password;
    private boolean usernameIsNotNull;
    private DataSource driverDataSource;

    public DataSourceConnectionFactory(DataSource driverDataSource, String username, String password) {
        this.driverDataSource = driverDataSource;
        this.username = username;
        this.password = password;
        if (!PoolStaticCenter.isBlank(username)) {
            this.usernameIsNotNull = true;
        }
    }

    @Override
    public Connection create() throws SQLException {
        if (this.usernameIsNotNull) {
            return this.driverDataSource.getConnection(this.username, this.password);
        }
        return this.driverDataSource.getConnection();
    }
}

