/*
 * Decompiled with CFR 0.152.
 */
package cn.beecp;

import cn.beecp.BeeDataSource;
import cn.beecp.BeeDataSourceConfig;
import cn.beecp.pool.PoolStaticCenter;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import javax.sql.DataSource;

public final class BeeDataSourceFactory
implements ObjectFactory {
    public DataSource create(BeeDataSourceConfig config) {
        return new BeeDataSource(config);
    }

    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        Reference ref = (Reference)obj;
        BeeDataSourceConfig config = new BeeDataSourceConfig();
        Map<String, Method> setMethodMap = PoolStaticCenter.getSetMethodMap(config.getClass());
        HashMap<String, Object> setValueMap = new HashMap<String, Object>(setMethodMap.size());
        for (String propertyName : setMethodMap.keySet()) {
            String configVal = this.getConfigValue(ref, propertyName);
            if (PoolStaticCenter.isBlank(configVal)) continue;
            setValueMap.put(propertyName, configVal);
        }
        PoolStaticCenter.setPropertiesValue(config, setMethodMap, setValueMap);
        String connectPropVal = this.getConfigValue(ref, "connectProperties");
        if (!PoolStaticCenter.isBlank(connectPropVal)) {
            String[] attributeArray;
            for (String attribute : attributeArray = connectPropVal.split("&")) {
                String[] pairs = attribute.split("=");
                if (pairs.length != 2) continue;
                config.addConnectProperty(pairs[0].trim(), pairs[1].trim());
                PoolStaticCenter.commonLog.info("beecp.connectProperties.{}={}", (Object)pairs[0].trim(), (Object)pairs[1].trim());
            }
        }
        return new BeeDataSource(config);
    }

    private final String getConfigValue(Reference ref, String propertyName) {
        String value = this.readConfig(ref, propertyName);
        if (PoolStaticCenter.isBlank(value)) {
            value = this.readConfig(ref, PoolStaticCenter.propertyNameToFieldId(propertyName, "-"));
        }
        if (PoolStaticCenter.isBlank(value)) {
            value = this.readConfig(ref, PoolStaticCenter.propertyNameToFieldId(propertyName, "_"));
        }
        return value;
    }

    private final String readConfig(Reference ref, String propertyName) {
        RefAddr refAddr = ref.get(propertyName);
        if (refAddr != null) {
            Object refObject = refAddr.getContent();
            if (refObject == null) {
                return null;
            }
            String value = refObject.toString().trim();
            if (!PoolStaticCenter.isBlank(value)) {
                PoolStaticCenter.commonLog.info("beecp.{}={}", (Object)propertyName, (Object)value);
                return value;
            }
        }
        return null;
    }
}

