/*
 * Decompiled with CFR 0.152.
 */
package cn.beecp;

import cn.beecp.BeeDataSourceConfig;
import cn.beecp.BeeDataSourceConfigException;
import cn.beecp.pool.ConnectionPool;
import cn.beecp.pool.ConnectionPoolMonitorVo;
import cn.beecp.pool.FastConnectionPool;
import cn.beecp.pool.PoolStaticCenter;
import cn.beecp.pool.ProxyConnectionBase;
import cn.beecp.xa.XaConnectionFactory;
import cn.beecp.xa.XaConnectionWrapper;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.HashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Logger;
import javax.sql.DataSource;
import javax.sql.XAConnection;
import javax.sql.XADataSource;

public class BeeDataSource
extends BeeDataSourceConfig
implements DataSource,
XADataSource {
    private static final HashMap<String, String> XaConnectionFactoryMap = new HashMap(5);
    private static final SQLException XaConnectionFactoryNotFound = new SQLException("xaConnectionFactory can't be null,please config xaConnectionFactory or xaConnectionFactoryClassName");
    private boolean inited;
    private ConnectionPool pool;
    private SQLException failedCause;
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
    private ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();
    private XaConnectionFactory xaConnectionFactory;

    public BeeDataSource() {
    }

    public BeeDataSource(BeeDataSourceConfig config) {
        try {
            config.copyTo(this);
            this.pool = this.createPool(this);
            this.inited = true;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public BeeDataSource(String driver, String url, String user, String password) {
        super(driver, url, user, password);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Connection getConnection() throws SQLException {
        if (this.inited) {
            return this.pool.getConnection();
        }
        if (this.writeLock.tryLock()) {
            try {
                if (this.inited) return this.pool.getConnection();
                this.failedCause = null;
                this.pool = this.createPool(this);
                this.inited = true;
                return this.pool.getConnection();
            }
            catch (Throwable e) {
                this.failedCause = e instanceof SQLException ? (SQLException)e : new SQLException(e);
                throw this.failedCause;
            }
            finally {
                this.writeLock.unlock();
            }
        } else {
            try {
                this.readLock.lock();
                if (this.failedCause == null) return this.pool.getConnection();
                throw this.failedCause;
            }
            finally {
                this.readLock.unlock();
            }
        }
    }

    @Override
    public XAConnection getXAConnection() throws SQLException {
        if (this.xaConnectionFactory == null) {
            throw XaConnectionFactoryNotFound;
        }
        ProxyConnectionBase proxyCon = (ProxyConnectionBase)this.getConnection();
        return new XaConnectionWrapper(this.xaConnectionFactory.create(proxyCon.getDelegate()), proxyCon);
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        throw new SQLException("Not support");
    }

    @Override
    public XAConnection getXAConnection(String user, String password) throws SQLException {
        throw new SQLException("Not support");
    }

    public void close() {
        if (this.pool != null) {
            try {
                this.pool.close();
            }
            catch (SQLException e) {
                PoolStaticCenter.commonLog.error("Error at closing connection pool,cause:", (Throwable)e);
            }
        }
    }

    public boolean isClosed() {
        return this.pool != null ? this.pool.isClosed() : true;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported");
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported");
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("Not supported");
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported");
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance(this)) {
            return (T)this;
        }
        throw new SQLException("Wrapped object was not an instance of " + iface);
    }

    public ConnectionPoolMonitorVo getPoolMonitorVo() throws SQLException {
        if (this.pool == null) {
            throw new SQLException("Connection pool not be initialized");
        }
        return this.pool.getMonitorVo();
    }

    public void clearAllConnections() throws SQLException {
        this.clearAllConnections(false);
    }

    public void clearAllConnections(boolean force) throws SQLException {
        if (this.pool == null) {
            throw new SQLException("Connection pool not be initialized");
        }
        this.pool.clearAllConnections(force);
    }

    private final ConnectionPool createPool(BeeDataSourceConfig config) throws SQLException {
        String driverType;
        this.xaConnectionFactory = this.tryCreateXAConnectionFactoryByConfig(config);
        if (this.xaConnectionFactory == null && !PoolStaticCenter.isBlank(config.getUrl()) && !PoolStaticCenter.isBlank(driverType = this.getDriverType(config.getUrl()))) {
            String xaConnectionFactoryClassName = XaConnectionFactoryMap.get(driverType);
            this.xaConnectionFactory = this.createXAConnectionFactoryByClassName(xaConnectionFactoryClassName);
        }
        ConnectionPool pool = this.createPoolInstanceByConfig(config);
        pool.init(config);
        return pool;
    }

    private String getDriverType(String url) {
        try {
            Driver driver = DriverManager.getDriver(url);
            if (url.indexOf("oracle") > 1) {
                return "oracle";
            }
            if (url.indexOf("mysql") > 1) {
                return "mysql" + driver.getMajorVersion();
            }
            if (url.indexOf("mariadb") > 1) {
                return "mariadb";
            }
            if (url.indexOf("postgresql") > 1) {
                return "postgresql";
            }
            return null;
        }
        catch (SQLException e) {
            PoolStaticCenter.commonLog.warn("Not found matched driver from driverManager by url", (Throwable)e);
            return null;
        }
    }

    private final ConnectionPool createPoolInstanceByConfig(BeeDataSourceConfig config) throws BeeDataSourceConfigException {
        String poolImplementClassName = config.getPoolImplementClassName();
        if (PoolStaticCenter.isBlank(poolImplementClassName)) {
            poolImplementClassName = FastConnectionPool.class.getName();
        }
        try {
            Class<?> poolClass = Class.forName(poolImplementClassName, true, this.getClass().getClassLoader());
            if (ConnectionPool.class.isAssignableFrom(poolClass)) {
                return (ConnectionPool)poolClass.newInstance();
            }
            throw new BeeDataSourceConfigException("poolImplementClassName error,must implement '" + ConnectionPool.class.getName() + "' interface");
        }
        catch (ClassNotFoundException e) {
            throw new BeeDataSourceConfigException("Not found connection pool class:" + poolImplementClassName);
        }
        catch (InstantiationException e) {
            throw new BeeDataSourceConfigException("Failed to instantiate connection pool class:" + poolImplementClassName, e);
        }
        catch (IllegalAccessException e) {
            throw new BeeDataSourceConfigException("Failed to instantiate connection pool class:" + poolImplementClassName, e);
        }
    }

    private final XaConnectionFactory tryCreateXAConnectionFactoryByConfig(BeeDataSourceConfig config) throws BeeDataSourceConfigException {
        if (config.getXaConnectionFactory() != null) {
            return config.getXaConnectionFactory();
        }
        return this.createXAConnectionFactoryByClassName(config.getXaConnectionFactoryClassName());
    }

    private final XaConnectionFactory createXAConnectionFactoryByClassName(String xaConnectionFactoryClassName) throws BeeDataSourceConfigException {
        if (!PoolStaticCenter.isBlank(xaConnectionFactoryClassName)) {
            try {
                Class<?> xaConnectionFactoryClass = Class.forName(xaConnectionFactoryClassName, true, this.getClass().getClassLoader());
                if (XaConnectionFactory.class.isAssignableFrom(xaConnectionFactoryClass)) {
                    return (XaConnectionFactory)xaConnectionFactoryClass.newInstance();
                }
                throw new BeeDataSourceConfigException("xaConnectionFactoryClassName error,must implement '" + XaConnectionFactory.class.getName() + "' interface");
            }
            catch (ClassNotFoundException e) {
                throw new BeeDataSourceConfigException("Not found XAConnection factory class:" + xaConnectionFactoryClassName);
            }
            catch (InstantiationException e) {
                throw new BeeDataSourceConfigException("Failed to instantiate XAConnection factory class:" + xaConnectionFactoryClassName, e);
            }
            catch (IllegalAccessException e) {
                throw new BeeDataSourceConfigException("Failed to instantiate XAConnection factory class:" + xaConnectionFactoryClassName, e);
            }
        }
        return null;
    }

    static {
        XaConnectionFactoryMap.put("oracle", "cn.beecp.xa.OracleXaConnectionFactory");
        XaConnectionFactoryMap.put("mariadb", "cn.beecp.xa.MariadbXaConnectionFactory");
        XaConnectionFactoryMap.put("mysql5", "cn.beecp.xa.Mysql5XaConnectionFactory");
        XaConnectionFactoryMap.put("mysql8", "cn.beecp.xa.Mysql8XaConnectionFactory");
        XaConnectionFactoryMap.put("postgresql", "cn.beecp.xa.PostgresXaConnectionFactory");
    }
}

