/*
 * Decompiled with CFR 0.152.
 */
package com.github.botaruibo.xvcode.generator;

import com.github.botaruibo.xvcode.generator.Generator;
import com.github.botaruibo.xvcode.generator.XRandoms;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;

public class PngVCGenerator
extends Generator {
    private static float bkAlpha = 0.7f;
    private static float fontAlpha = 0.7f;
    private static float ovalSize = 4.0f;
    private static int ovalCount = 20;

    public PngVCGenerator() {
    }

    public PngVCGenerator(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public PngVCGenerator(int width, int height, int len) {
        this(width, height);
        this.len = len;
    }

    public PngVCGenerator(int width, int height, int len, Font font) {
        this(width, height, len);
        this.font = font;
    }

    public PngVCGenerator(int width, int height, int len, Font font, float pbkAlpha, float pFontAlpha, float pOvalSize, int pOvalCount) {
        this(width, height, len, font);
        bkAlpha = pbkAlpha;
        fontAlpha = pFontAlpha;
        ovalSize = pOvalSize;
        ovalCount = pOvalCount;
    }

    @Override
    public OutputStream write2out(OutputStream os) {
        if (os == null) {
            return null;
        }
        BufferedImage bi = this.getValidCodeImage(this.alphas());
        try {
            ImageIO.write((RenderedImage)bi, "png", os);
            os.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return os;
    }

    private BufferedImage getValidCodeImage(char[] strs) {
        Color color;
        BufferedImage bi = new BufferedImage(this.width, this.height, 1);
        Graphics2D g2d = (Graphics2D)bi.getGraphics();
        int len = strs.length;
        g2d.setColor(Color.WHITE);
        g2d.fillRect(0, 0, this.width, this.height);
        g2d.setStroke(new BasicStroke(ovalSize));
        AlphaComposite ac3 = AlphaComposite.getInstance(3, bkAlpha);
        g2d.setComposite(ac3);
        for (int i = 0; i < ovalCount; ++i) {
            color = this.color(150, 250);
            g2d.setColor(color);
            g2d.drawOval(XRandoms.num(this.width), XRandoms.num(this.height), 10 + XRandoms.num(10), 10 + XRandoms.num(10));
        }
        g2d.setFont(this.font);
        ac3 = AlphaComposite.getInstance(3, fontAlpha);
        g2d.setComposite(ac3);
        int h = this.height - (this.height - this.font.getSize() >> 1);
        int w = this.width / len;
        int size = w - this.font.getSize() + 2;
        for (int i = 0; i < len; ++i) {
            color = new Color(20 + XRandoms.num(110), 20 + XRandoms.num(110), 20 + XRandoms.num(110));
            g2d.setColor(color);
            int degree = XRandoms.num(90);
            degree = XRandoms.num(2) == 0 ? -degree : degree;
            g2d.rotate(Math.toRadians(degree), this.width - (len - i) * w + w / 2, this.height / 2 + 2);
            g2d.drawString(strs[i] + "", this.width - (len - i) * w + size, h - 4);
            g2d.rotate(-Math.toRadians(degree), this.width - (len - i) * w + w / 2, this.height / 2 + 2);
        }
        g2d.dispose();
        return bi;
    }

    @Override
    public BufferedImage getValidCodeImage() {
        return this.getValidCodeImage(this.alphas());
    }
}

