/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.open.api.impl;

import cn.binarywang.wx.miniapp.api.WxMaService;
import java.util.HashMap;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.open.api.WxOpenMaPrivacyService;
import me.chanjar.weixin.open.bean.ma.privacy.ApplyPrivacyInterface;
import me.chanjar.weixin.open.bean.ma.privacy.ApplyPrivacyInterfaceResult;
import me.chanjar.weixin.open.bean.ma.privacy.GetPrivacyInterfaceResult;
import me.chanjar.weixin.open.bean.ma.privacy.GetPrivacySettingResult;
import me.chanjar.weixin.open.bean.ma.privacy.SetPrivacySetting;
import me.chanjar.weixin.open.bean.ma.privacy.UploadPrivacyFileResult;
import me.chanjar.weixin.open.util.json.WxOpenGsonBuilder;

public class WxOpenMaPrivacyServiceImpl
implements WxOpenMaPrivacyService {
    private final WxMaService wxMaService;

    @Override
    public GetPrivacySettingResult getPrivacySetting(Integer privacyVer) throws WxErrorException {
        HashMap<String, Integer> params = new HashMap<String, Integer>(1);
        if (privacyVer != null) {
            params.put("privacy_ver", privacyVer);
        }
        String json = this.wxMaService.post("https://api.weixin.qq.com/cgi-bin/component/getprivacysetting", params);
        return (GetPrivacySettingResult)WxOpenGsonBuilder.create().fromJson(json, GetPrivacySettingResult.class);
    }

    @Override
    public void setPrivacySetting(SetPrivacySetting dto) throws WxErrorException {
        this.wxMaService.post("https://api.weixin.qq.com/cgi-bin/component/setprivacysetting", (Object)dto);
    }

    @Override
    public UploadPrivacyFileResult uploadPrivacyFile(String content) throws WxErrorException {
        throw new WxErrorException(new WxError(5003, "\u6682\u672a\u5b9e\u73b0\u7528\u6237\u9690\u79c1\u6307\u5f15\u5185\u5bb9\u4e0a\u4f20"));
    }

    @Override
    public GetPrivacyInterfaceResult getPrivacyInterface() throws WxErrorException {
        String json = this.wxMaService.get("https://api.weixin.qq.com/wxa/security/get_privacy_interface", "");
        return (GetPrivacyInterfaceResult)WxOpenGsonBuilder.create().fromJson(json, GetPrivacyInterfaceResult.class);
    }

    @Override
    public ApplyPrivacyInterfaceResult applyPrivacyInterface(ApplyPrivacyInterface dto) throws WxErrorException {
        String json = this.wxMaService.post("https://api.weixin.qq.com/wxa/security/apply_privacy_interface", (Object)dto);
        return (ApplyPrivacyInterfaceResult)WxOpenGsonBuilder.create().fromJson(json, ApplyPrivacyInterfaceResult.class);
    }

    public WxOpenMaPrivacyServiceImpl(WxMaService wxMaService) {
        this.wxMaService = wxMaService;
    }
}

