/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.session;

import cn.org.atool.fluent.mybatis.base.entity.AMapping;
import cn.org.atool.fluent.mybatis.base.entity.IMapping;
import cn.org.atool.fluent.mybatis.base.model.KeyMap;
import cn.org.atool.fluent.mybatis.base.provider.StatementBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.session.Configuration;

public class ConfigurationKit {
    private final Configuration configuration;
    private final Map<String, IMapping> inserts = new HashMap<String, IMapping>();
    private final Map<String, IMapping> batchInserts = new HashMap<String, IMapping>();
    private final Map<String, IMapping> listEntities = new HashMap<String, IMapping>();

    public ConfigurationKit(Configuration configuration, KeyMap<AMapping> mappers) {
        this.configuration = configuration;
        for (Map.Entry<String, AMapping> entry : mappers.entrySet()) {
            this.inserts.put(entry.getKey() + "." + "insert", entry.getValue());
            this.batchInserts.put(entry.getKey() + "." + "insertBatch", entry.getValue());
            this.listEntities.put(entry.getKey() + "." + "internalListEntity", entry.getValue());
        }
    }

    public ConfigurationKit insert() {
        for (Map.Entry<String, IMapping> entry : this.inserts.entrySet()) {
            IMapping m = entry.getValue();
            if (m.primaryMapping() == null) continue;
            this.replaced(entry.getKey(), m, StatementBuilder::selectKeyStatementOfInsert);
        }
        this.inserts.clear();
        return this;
    }

    public ConfigurationKit batchInsert() {
        for (Map.Entry<String, IMapping> entry : this.batchInserts.entrySet()) {
            IMapping m = entry.getValue();
            if (m.primaryMapping() == null) continue;
            this.replaced(entry.getKey(), m, StatementBuilder::selectKeyStatementOfBatchInsert);
        }
        this.batchInserts.clear();
        return this;
    }

    public ConfigurationKit listEntity() {
        for (Map.Entry<String, IMapping> entry : this.listEntities.entrySet()) {
            IMapping m = entry.getValue();
            this.replaced(entry.getKey(), m, StatementBuilder::listEntityStatement);
        }
        this.listEntities.clear();
        return this;
    }

    private void replaced(String statementId, IMapping mapping, Function<StatementBuilder, MappedStatement> replaced) {
        if (this.configuration.hasStatement(statementId, false)) {
            MappedStatement existed = this.configuration.getMappedStatement(statementId, false);
            MappedStatement newer = replaced.apply(new StatementBuilder(mapping, existed));
            this.configuration.mappedStatements.remove(statementId);
            this.configuration.addMappedStatement(newer);
        }
    }
}

