/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.utility;

import cn.org.atool.fluent.mybatis.If;
import cn.org.atool.fluent.mybatis.annotation.FluentMybatis;
import cn.org.atool.fluent.mybatis.annotation.NotField;
import cn.org.atool.fluent.mybatis.base.IEntity;
import cn.org.atool.fluent.mybatis.base.RichEntity;
import cn.org.atool.fluent.mybatis.exception.FluentMybatisException;
import cn.org.atool.fluent.mybatis.mapper.PrinterMapper;
import cn.org.atool.fluent.mybatis.spring.MapperFactory;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MybatisUtil {
    static Map<Character, String> Escape_Char;
    public static final char UNDERLINE = '_';
    private static final char[] Variant_Char;

    public static String format(String target, Object ... params) {
        if (target.contains("%s") && If.notEmpty(params)) {
            return String.format(target, params);
        }
        return target;
    }

    public static List<Field> getFieldList(Class entityClass) {
        Field[] fields;
        HashMap<String, Field> map = new HashMap<String, Field>();
        for (Field field : fields = entityClass.getDeclaredFields()) {
            if (MybatisUtil.isStatic(field) || field.getAnnotation(NotField.class) != null || map.containsKey(field.getName())) continue;
            map.put(field.getName(), field);
        }
        return new ArrayList<Field>(map.values());
    }

    private static boolean isStatic(Field field) {
        return Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers());
    }

    public static void assertNotNull(String property, Object value) {
        if (value == null) {
            throw FluentMybatisException.instance("the parameter[" + property + "] can't be null.", property);
        }
    }

    public static void assertTrue(String message, boolean value) {
        if (!value) {
            throw new FluentMybatisException(message);
        }
    }

    public static <T> void assertNotNull(String property, T value1, T value2) {
        if (value1 == null || value2 == null) {
            throw FluentMybatisException.instance("the parameter[%s] can't be null.", property);
        }
    }

    public static void assertNotBlank(String property, String value) {
        if (If.isBlank(value)) {
            throw FluentMybatisException.instance("the parameter[%s] can't be blank.", property);
        }
    }

    public static void assertNotEmpty(String property, Collection list) {
        if (list == null || list.size() == 0) {
            throw FluentMybatisException.instance("the parameter[%s] can't be empty.", property);
        }
    }

    public static void assertNotEmpty(String property, Map map) {
        if (map == null || map.size() == 0) {
            throw FluentMybatisException.instance("the parameter[%s] can't be empty.", property);
        }
    }

    public static void assertNotEmpty(String property, Object[] array) {
        if (array == null || array.length == 0) {
            throw FluentMybatisException.instance("the parameter[%s] can't be empty.", property);
        }
    }

    public static void isTrue(boolean expression, String message, Object ... params) {
        if (!expression) {
            throw FluentMybatisException.instance(message, params);
        }
    }

    public static void notNull(Object object, String message, Object ... params) {
        MybatisUtil.isTrue(object != null, message, params);
    }

    public static Integer[] toArray(int[] nums) {
        if (nums == null) {
            return null;
        }
        return (Integer[])Arrays.stream(nums).boxed().toArray(Integer[]::new);
    }

    public static Long[] toArray(long[] nums) {
        if (nums == null) {
            return null;
        }
        return (Long[])Arrays.stream(nums).boxed().toArray(Long[]::new);
    }

    public static <O> boolean isCollection(O ... args) {
        return args != null && args.length == 1 && args[0] instanceof Collection;
    }

    public static String trim(String str) {
        return If.isBlank(str) ? "" : str.trim();
    }

    public static String tableName(String klass, String prefix, String suffix) {
        if (klass.endsWith(suffix)) {
            klass = klass.substring(0, klass.length() - suffix.length());
        }
        return prefix + MybatisUtil.camelToUnderline(klass, false);
    }

    public static String camelToUnderline(String string, boolean toUpper) {
        if (If.isBlank(string)) {
            return "";
        }
        int len = string.length();
        StringBuilder buff = new StringBuilder(len + 10);
        for (int pos = 0; pos < len; ++pos) {
            char ch = string.charAt(pos);
            if (pos != 0 && Character.isUpperCase(ch)) {
                buff.append('_');
            }
            if (toUpper) {
                buff.append(Character.toUpperCase(ch));
                continue;
            }
            buff.append(Character.toLowerCase(ch));
        }
        return buff.toString();
    }

    public static String underlineToCamel(String input, boolean firstCapital) {
        if (If.isBlank(input)) {
            return "";
        }
        boolean isAllUpper = MybatisUtil.isAllUpper(input);
        boolean first = true;
        boolean underline = false;
        StringBuilder buff = new StringBuilder(input.length());
        for (char ch : input.toCharArray()) {
            if (ch == '_') {
                if (first) continue;
                underline = true;
                continue;
            }
            if (first) {
                buff.append(firstCapital ? Character.toUpperCase(ch) : Character.toLowerCase(ch));
            } else if (underline) {
                buff.append(Character.toUpperCase(ch));
            } else if (isAllUpper) {
                buff.append(Character.toLowerCase(ch));
            } else {
                buff.append(ch);
            }
            first = false;
            underline = false;
        }
        return buff.toString();
    }

    private static boolean isAllUpper(String text) {
        for (char ch : text.toCharArray()) {
            if (ch < 'a' || ch > 'z') continue;
            return false;
        }
        return true;
    }

    public static String capitalFirst(String name) {
        return MybatisUtil.capitalFirst(name, "");
    }

    public static String capitalFirst(String name, String del) {
        if (!If.isBlank(name)) {
            if (del != null && name.startsWith(del)) {
                name = name.substring(del.length());
            }
            return name.substring(0, 1).toUpperCase() + name.substring(1);
        }
        return "";
    }

    public static String lowerFirst(String name, String del) {
        if (!If.isBlank(name)) {
            if (del != null && name.startsWith(del)) {
                name = name.substring(del.length());
            }
            return name.substring(0, 1).toLowerCase() + name.substring(1);
        }
        return "";
    }

    public static String methodNameOfEntity(String method, Class entityClass) {
        return method + "Of" + entityClass.getSimpleName();
    }

    public static String methodNameOfEntity(String method, String entityClass) {
        return method + "Of" + entityClass;
    }

    public static boolean isColumnName(String input) {
        if (If.isBlank(input)) {
            return false;
        }
        if (!MybatisUtil.isLetter((input = input.toLowerCase()).charAt(0)) || "true".equals(input) || "false".equals(input)) {
            return false;
        }
        for (char ch : input.toCharArray()) {
            if (MybatisUtil.isVariantChar(ch)) continue;
            return false;
        }
        return true;
    }

    public static boolean isLetter(char ch) {
        return ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch == '_' || ch == '$';
    }

    public static boolean isTableName(String table) {
        if (If.isBlank(table)) {
            return false;
        }
        for (char c : table.toCharArray()) {
            if (c < '\u0080' && Variant_Char[c] != '\u0000') continue;
            return false;
        }
        return true;
    }

    public static boolean isVariantChar(char ch) {
        return ch < '\u0080' && Variant_Char[ch] == '\u0001';
    }

    public static boolean isSpace(char ch) {
        return ch == ' ' || ch == '\t' || ch == '\n' || ch == '\r';
    }

    public static boolean isDigit(char ch) {
        return ch >= '0' && ch <= '9';
    }

    public static List<String> parseAlias(String column) {
        int pos = -1;
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder buff = new StringBuilder();
        for (char c : (column + " ").toCharArray()) {
            if (pos <= 0 && MybatisUtil.isSpace(c)) {
                pos = 0;
                continue;
            }
            if (pos == 0 && (c == 'a' || c == 'A')) {
                pos = 1;
                continue;
            }
            if (pos == 1 && (c == 's' || c == 'S')) {
                pos = 2;
                continue;
            }
            if ((pos == 2 || pos == 3) && MybatisUtil.isSpace(c)) {
                pos = 3;
                continue;
            }
            if (pos >= 3 && MybatisUtil.isVariantChar(c)) {
                pos = 4;
                buff.append(c);
                continue;
            }
            if (pos == 4 && (MybatisUtil.isSpace(c) || c == ',')) {
                list.add(buff.toString());
                buff = new StringBuilder();
                pos = -1;
                continue;
            }
            pos = -1;
        }
        return list;
    }

    public static String unwrap(String column) {
        int len = column.length();
        char begin = column.charAt(0);
        char last = column.charAt(len - 1);
        if (!MybatisUtil.isVariantChar(begin) && !MybatisUtil.isVariantChar(last)) {
            return column.substring(1, len - 1);
        }
        return column;
    }

    public static <T> T value(Object target, Field ... fields) {
        Object value = target;
        try {
            for (Field f : fields) {
                if (value == null) {
                    return null;
                }
                value = f.get(value);
            }
            return (T)value;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static Field field(Class declared, String fieldName) {
        try {
            Field field = declared.getDeclaredField(fieldName);
            field.setAccessible(true);
            return field;
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<String> splitByComma(String text) {
        return MybatisUtil.splitBy(Collections.singletonList(Character.valueOf(',')), text);
    }

    public static List<String> splitBySpace(String text) {
        return MybatisUtil.splitBy(Arrays.asList(Character.valueOf(' '), Character.valueOf('\t'), Character.valueOf('\n'), Character.valueOf('\r')), text);
    }

    public static List<String> splitBy(Collection<Character> delimiters, String text) {
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder item = new StringBuilder();
        char quotation = '\u0000';
        int slash = 0;
        for (char ch : text.toCharArray()) {
            if (ch == '\\') {
                item.append(ch);
                slash = (char)(slash + 1);
                continue;
            }
            if (delimiters.contains(Character.valueOf(ch)) && quotation == '\u0000') {
                list.add(item.toString());
                item = new StringBuilder();
                slash = 0;
                continue;
            }
            item.append(ch);
            if (slash % 2 == 1) {
                slash = 0;
                continue;
            }
            if (ch == '\'' || ch == '\"') {
                if (quotation == '\u0000') {
                    quotation = ch;
                } else if (quotation == ch) {
                    quotation = '\u0000';
                }
            }
            slash = 0;
        }
        list.add(item.toString());
        return list;
    }

    public static String joinWithSpace(Object ... objects) {
        return Stream.of(objects).map(String::valueOf).map(String::trim).filter(If::notBlank).collect(Collectors.joining(" "));
    }

    public static Class<? extends IEntity> entityClass(Class eClass) {
        for (Class aClass = eClass; aClass != Object.class && aClass != RichEntity.class; aClass = aClass.getSuperclass()) {
            if (aClass.getAnnotation(FluentMybatis.class) == null) continue;
            return aClass;
        }
        throw new RuntimeException("the class[" + eClass.getName() + "] is not a @FluentMybatis Entity.");
    }

    public static void isMapperFactoryInitialized() {
        if (MapperFactory.isInitialized() || PrinterMapper.isPrint()) {
            return;
        }
        throw new FluentMybatisException("Please add MapperFactory to spring container management: \n\n    @Bean\n    public MapperFactory mapperFactory() {\n        return new MapperFactory();\n    }\n\n");
    }

    public static String getVersionBanner() {
        Package pkg = MybatisUtil.class.getPackage();
        String version = pkg != null ? pkg.getImplementationVersion() : "";
        return "\n\n      _____   _                          _       \n     |  ___| | |  _   _    ___   _ __   | |_     \n     | |_    | | | | | |  / _ \\ | '_ \\  | __|    \n     |  _|   | | | |_| | |  __/ | | | | | |_     \n  __ |_|     |_|  \\__,_|  \\___| |_|_|_|  \\__|    \n |  \\/  |  _   _  | |__     __ _  | |_  (_)  ___ \n | |\\/| | | | | | | '_ \\   / _` | | __| | | / __|\n | |  | | | |_| | | |_) | | (_| | | |_  | | \\__ \\\n |_|  |_|  \\__, | |_.__/   \\__,_|  \\__| |_| |___/\n           |___/                                 " + (version == null ? "" : "\n" + version + " \n");
    }

    static {
        int c;
        Escape_Char = new HashMap<Character, String>();
        Escape_Char.put(Character.valueOf('\u0000'), "\\0");
        Escape_Char.put(Character.valueOf('\n'), "\\n");
        Escape_Char.put(Character.valueOf('\r'), "\\r");
        Escape_Char.put(Character.valueOf('\\'), "\\\\");
        Escape_Char.put(Character.valueOf('\''), "\\'");
        Escape_Char.put(Character.valueOf('\"'), "\\\"");
        Escape_Char.put(Character.valueOf('\u001a'), "\\Z");
        Variant_Char = new char[128];
        for (int i = 0; i < 128; ++i) {
            MybatisUtil.Variant_Char[i] = '\u0000';
        }
        for (c = 65; c <= 90; c = (int)((char)(c + 1))) {
            MybatisUtil.Variant_Char[c] = '\u0001';
        }
        for (c = 97; c <= 122; c = (int)((char)(c + 1))) {
            MybatisUtil.Variant_Char[c] = '\u0001';
        }
        for (c = 48; c <= 57; c = (int)((char)(c + 1))) {
            MybatisUtil.Variant_Char[c] = '\u0001';
        }
        MybatisUtil.Variant_Char[95] = '\u0001';
        MybatisUtil.Variant_Char[45] = '\u0001';
        MybatisUtil.Variant_Char[36] = '\u0001';
    }
}

