/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.utility;

import cn.org.atool.fluent.mybatis.functions.IGetter;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Method;

public class LambdaUtil {
    public static <E> String resolveGetter(IGetter<E> getter) {
        String method = LambdaUtil.lambdaName(getter);
        return LambdaUtil.validateMethod(method);
    }

    public static <E> String resolve(IGetter<E> getter) {
        return LambdaUtil.lambdaName(getter);
    }

    private static String lambdaName(Object lambda) {
        try {
            String m_WRITE_REPLACE = "writeReplace";
            Method writeReplace = lambda.getClass().getDeclaredMethod(m_WRITE_REPLACE, new Class[0]);
            boolean accessible = writeReplace.isAccessible();
            writeReplace.setAccessible(Boolean.TRUE);
            SerializedLambda serializedLambda = (SerializedLambda)writeReplace.invoke(lambda, new Object[0]);
            String method = serializedLambda.getImplMethodName();
            writeReplace.setAccessible(accessible);
            return method;
        }
        catch (Exception e) {
            throw new RuntimeException("can't parser getter name of " + lambda.getClass().getSimpleName(), e);
        }
    }

    private static String validateMethod(String method) {
        if (method.startsWith("get")) {
            return method.substring(3, 4).toLowerCase() + method.substring(4);
        }
        if (method.startsWith("is")) {
            return method.substring(2, 3).toLowerCase() + method.substring(3);
        }
        throw new RuntimeException("not a getter method, please use lambda as 'entity::getXyz'");
    }
}

