/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.spring;

import cn.org.atool.fluent.mybatis.base.entity.AMapping;
import cn.org.atool.fluent.mybatis.base.intf.IRelation;
import cn.org.atool.fluent.mybatis.base.mapper.IEntityMapper;
import cn.org.atool.fluent.mybatis.functions.IExecutor;
import cn.org.atool.fluent.mybatis.utility.RefKit;
import java.util.Collection;
import java.util.List;
import org.apache.ibatis.session.ConfigurationKit;
import org.apache.ibatis.session.SqlSessionFactory;

public interface IMapperFactory {
    public Collection<IEntityMapper> getMappers();

    public Collection<IRelation> getRelations();

    public Collection<SqlSessionFactory> getSessionFactories();

    public List<IExecutor> getInitializers();

    default public void init() {
        Collection<IEntityMapper> mappers = this.getMappers();
        for (IEntityMapper iEntityMapper : mappers) {
            AMapping mapping = (AMapping)iEntityMapper.mapping();
            RefKit.ENTITY_MAPPING.put(mapping.entityClass(), mapping);
            RefKit.TABLE_MAPPING.put(mapping.getTableName(), mapping);
            RefKit.ENTITY_MAPPER.put(mapping.entityClass(), iEntityMapper);
            RefKit.MAPPER_MAPPING.put(mapping.mapperClass(), mapping);
        }
        RefKit.ENTITY_MAPPING.unmodified();
        RefKit.TABLE_MAPPING.unmodified();
        RefKit.ENTITY_MAPPER.unmodified();
        RefKit.MAPPER_MAPPING.unmodified();
        this.getInitializers().forEach(IExecutor::execute);
        Collection<IRelation> relations = this.getRelations();
        for (IRelation relation : relations) {
            relation.initialize();
        }
        RefKit.relations.unmodified();
        Collection<SqlSessionFactory> collection = this.getSessionFactories();
        for (SqlSessionFactory factory : collection) {
            new ConfigurationKit(factory.getConfiguration(), RefKit.MAPPER_MAPPING).insert().batchInsert().listEntity();
        }
    }
}

