/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.segment.list;

import cn.org.atool.fluent.mybatis.If;
import cn.org.atool.fluent.mybatis.segment.fragment.Column;
import cn.org.atool.fluent.mybatis.segment.fragment.Fragments;
import cn.org.atool.fluent.mybatis.segment.fragment.IFragment;
import cn.org.atool.fluent.mybatis.segment.fragment.KeyFrag;
import cn.org.atool.fluent.mybatis.segment.list.BaseSegmentList;
import java.util.ArrayList;
import java.util.List;

public class WhereSegmentList
extends BaseSegmentList {
    private final List<Column> columns = new ArrayList<Column>();

    public WhereSegmentList() {
        this.segments.setDelimiter(" ").setFilter(NOT_ONLY_KEY);
    }

    @Override
    public WhereSegmentList add(KeyFrag keyword, IFragment ... segments) {
        if (If.isEmpty(segments)) {
            return this;
        }
        IFragment merged = this.segments.isEmpty() ? Fragments.SEG_EMPTY : keyword;
        boolean needSpace = false;
        for (IFragment seg : segments) {
            if (needSpace) {
                merged = merged.plus(Fragments.SEG_SPACE);
            } else {
                needSpace = true;
            }
            merged = merged.plus(seg);
            if (!(seg instanceof Column)) continue;
            this.columns.add((Column)seg);
        }
        this.segments.add(merged);
        return this;
    }

    @Override
    public IFragment get() {
        return super.merge(Fragments.SEG_EMPTY);
    }

    public void clear() {
        this.segments.clear();
    }

    public boolean containColumn(String column) {
        if (If.isBlank(column)) {
            return false;
        }
        for (Column segment : this.columns) {
            if (!Column.columnEquals(segment, column)) continue;
            return true;
        }
        return false;
    }
}

