/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.segment.fragment;

import cn.org.atool.fluent.mybatis.If;
import cn.org.atool.fluent.mybatis.base.entity.IMapping;
import cn.org.atool.fluent.mybatis.segment.fragment.CachedFrag;
import cn.org.atool.fluent.mybatis.segment.fragment.Column;
import cn.org.atool.fluent.mybatis.segment.fragment.Fragments;
import cn.org.atool.fluent.mybatis.segment.fragment.IFragment;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class JoiningFrag
implements IFragment {
    private String delimiter;
    private Predicate<String> filter = null;
    protected final List<IFragment> segments = new ArrayList<IFragment>();

    public JoiningFrag(String delimiter) {
        this.delimiter = If.isBlank(delimiter) ? "" : delimiter;
    }

    @Override
    public boolean notEmpty() {
        return !this.segments.isEmpty();
    }

    @Override
    public String get(IMapping mapping) {
        if (this.isEmpty()) {
            return "";
        }
        return this.merge(mapping);
    }

    private String merge(IMapping mapping) {
        ArrayList<String> list = new ArrayList<String>(this.segments.size());
        for (IFragment seg : this.segments) {
            String text = seg.get(mapping);
            if (this.filter != null && !this.filter.test(text)) continue;
            list.add(text);
        }
        String text = String.join((CharSequence)this.delimiter, list);
        return text.trim();
    }

    public JoiningFrag add(IFragment ... segments) {
        Stream.of(segments).filter(Objects::nonNull).filter(IFragment::notEmpty).forEach(this.segments::add);
        return this;
    }

    public JoiningFrag add(String segment) {
        this.segments.add(CachedFrag.set(segment));
        return this;
    }

    public int size() {
        return this.segments.size();
    }

    public static JoiningFrag get(String delimiter) {
        return new JoiningFrag(delimiter);
    }

    public static JoiningFrag get() {
        return new JoiningFrag("");
    }

    public boolean isEmpty() {
        return this.segments.isEmpty();
    }

    public void removeColumn(String column) {
        this.segments.removeIf(segment -> Column.columnEquals(segment, column));
    }

    public void forEach(Consumer<IFragment> consumer) {
        this.segments.forEach(consumer);
    }

    public IFragment last() {
        if (this.segments.size() > 0) {
            return this.segments.get(this.segments.size() - 1);
        }
        return Fragments.SEG_EMPTY;
    }

    public void clear() {
        this.segments.clear();
    }

    public IFragment[] toArray() {
        return this.segments.toArray(new IFragment[0]);
    }

    public String toString() {
        return this.segments.stream().map(Object::toString).collect(Collectors.joining(this.delimiter == null ? ";" : this.delimiter));
    }

    public JoiningFrag setDelimiter(String delimiter) {
        this.delimiter = delimiter;
        return this;
    }

    public JoiningFrag setFilter(Predicate<String> filter) {
        this.filter = filter;
        return this;
    }

    public List<IFragment> getSegments() {
        return this.segments;
    }
}

