/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.segment.fragment;

import cn.org.atool.fluent.mybatis.If;
import cn.org.atool.fluent.mybatis.base.crud.IWrapper;
import cn.org.atool.fluent.mybatis.base.entity.IMapping;
import cn.org.atool.fluent.mybatis.base.model.FieldMapping;
import cn.org.atool.fluent.mybatis.segment.BaseWrapper;
import cn.org.atool.fluent.mybatis.segment.fragment.CachedFrag;
import cn.org.atool.fluent.mybatis.segment.fragment.IFragment;
import cn.org.atool.fluent.mybatis.utility.MybatisUtil;
import java.util.Objects;

public class Column
extends CachedFrag {
    private final String tAlias;
    public final String column;
    private final FieldMapping mapping;
    static final String Wrapper_Para = ".data.parameters.";

    private Column(IWrapper wrapper, String column, FieldMapping mapping) {
        super(m -> Column.wrap(m, wrapper, column));
        this.column = column;
        this.tAlias = wrapper.getTableAlias();
        this.mapping = mapping == null ? ((BaseWrapper)wrapper).column(column) : mapping;
    }

    private Column(String tAlias, String column, FieldMapping mapping) {
        super(m -> Column.wrap(m, tAlias, column));
        this.tAlias = tAlias;
        this.column = column;
        this.mapping = mapping;
    }

    public boolean isAssignableFrom(Object para) {
        if (para == null || this.mapping == null || this.mapping.javaType == null || this.mapping.typeHandler == null) {
            return false;
        }
        Class<?> pClass = para.getClass();
        return this.mapping.javaType.isAssignableFrom(pClass);
    }

    @Override
    public boolean notEmpty() {
        return If.notBlank(this.column);
    }

    @Override
    public String toString() {
        return this.column;
    }

    public static boolean isFieldAndAssignableFrom(IFragment column, Object para) {
        if (!(column instanceof Column)) {
            return false;
        }
        return ((Column)column).isAssignableFrom(para);
    }

    public static String expression(IFragment column, String paraName, Object para) {
        StringBuilder buff = new StringBuilder("#{").append("ew").append(Wrapper_Para).append(paraName);
        if (Column.isFieldAndAssignableFrom(column, para)) {
            Column _column = (Column)column;
            buff.append(", ").append("javaType=").append(_column.mapping.javaType.getName()).append(", ").append("typeHandler=").append(_column.mapping.typeHandler.getName());
        }
        return buff.append("}").toString();
    }

    public static Column set(IWrapper wrapper, String column) {
        if (wrapper == null) {
            return new Column("", column, null);
        }
        return new Column(wrapper, column, null);
    }

    public static Column set(IWrapper wrapper, FieldMapping mapping) {
        if (wrapper == null) {
            return new Column("", mapping.column, mapping);
        }
        return new Column(wrapper, mapping.column, mapping);
    }

    public static Column set(String tAlias, String column) {
        return new Column(tAlias, column, null);
    }

    private static String wrap(IMapping mapping, String tAlias, String column) {
        if (If.isBlank(column)) {
            return "";
        }
        if (If.isBlank(tAlias)) {
            return mapping.db().wrap(column);
        }
        return tAlias + '.' + mapping.db().wrap(column);
    }

    private static String wrap(IMapping mapping, IWrapper wrapper, String column) {
        if (If.isBlank(column)) {
            return "";
        }
        String columnAs = column;
        if (Column.isColumnNameAndNotAlias(wrapper, column)) {
            columnAs = mapping.db().wrap(column);
        }
        if (wrapper == null || If.isBlank(wrapper.getTableAlias())) {
            return columnAs;
        }
        if (Column.isColumnNameAndNotAlias(wrapper, column)) {
            return wrapper.getTableAlias() + '.' + columnAs;
        }
        return columnAs;
    }

    private static boolean isColumnNameAndNotAlias(IWrapper wrapper, String column) {
        if (wrapper == null) {
            return false;
        }
        if (!MybatisUtil.isColumnName(column)) {
            return false;
        }
        return !wrapper.data().getFieldAlias().contains(column);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return Objects.equals(this.column, ((Column)o).column);
    }

    public int hashCode() {
        return this.column != null ? this.column.hashCode() : 0;
    }

    public static boolean columnEquals(Object seg, String column) {
        if (seg instanceof Column) {
            return Objects.equals(column, ((Column)seg).column);
        }
        return false;
    }

    public String getTAlias() {
        return this.tAlias;
    }

    public String getColumn() {
        return this.column;
    }

    public FieldMapping getMapping() {
        return this.mapping;
    }
}

