/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.segment;

import cn.org.atool.fluent.mybatis.base.crud.BaseQuery;
import cn.org.atool.fluent.mybatis.base.crud.IWrapper;
import cn.org.atool.fluent.mybatis.segment.fragment.Column;
import cn.org.atool.fluent.mybatis.segment.fragment.IFragment;
import cn.org.atool.fluent.mybatis.segment.fragment.JoiningFrag;
import cn.org.atool.fluent.mybatis.segment.fragment.KeyFrag;
import cn.org.atool.fluent.mybatis.segment.model.Parameters;
import cn.org.atool.fluent.mybatis.segment.model.WrapperData;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class JoinWrapperData
extends WrapperData {
    private final List<BaseQuery> queries;
    private final JoiningFrag tables = JoiningFrag.get().setDelimiter(" ");
    private final Set<KeyFrag> mergedFlag = new HashSet<KeyFrag>(8);

    public JoinWrapperData(BaseQuery query, List<BaseQuery> queries, Parameters shared) {
        super(query, shared);
        this.queries = queries;
        this.tables.add(this.wrapper.data().table());
    }

    public void addTable(IFragment table) {
        this.tables.add(table);
    }

    @Override
    public IFragment table() {
        return this.tables;
    }

    @Override
    public IFragment select() {
        if (!this.mergedFlag.contains(KeyFrag.SELECT)) {
            this.select.add(this.wrapper.data().select);
            for (BaseQuery query : this.queries) {
                this.select.add(query.data.select);
            }
            if (this.select.isEmpty()) {
                this.wrapper.allFields().forEach(c -> this.select.add(Column.set(this.wrapper, (String)c)));
                for (BaseQuery query : this.queries) {
                    query.allFields().forEach(c -> this.select.add(Column.set((IWrapper)query, (String)c)));
                }
            }
            this.mergedFlag.add(KeyFrag.SELECT);
        }
        return super.select();
    }

    @Override
    public JoiningFrag where() {
        if (!this.mergedFlag.contains(KeyFrag.WHERE)) {
            this.segments().where.add(KeyFrag.AND, this.wrapper.data().where());
            for (BaseQuery query : this.queries) {
                this.segments().where.add(KeyFrag.AND, query.data.where());
            }
            this.mergedFlag.add(KeyFrag.WHERE);
        }
        return super.where();
    }

    @Override
    public JoiningFrag groupBy() {
        if (!this.mergedFlag.contains(KeyFrag.GROUP_BY)) {
            this.segments().groupBy.add(KeyFrag.GROUP_BY, this.wrapper.data().groupBy());
            for (BaseQuery query : this.queries) {
                this.segments().groupBy.add(KeyFrag.GROUP_BY, query.data.groupBy());
            }
            this.mergedFlag.add(KeyFrag.GROUP_BY);
        }
        return super.groupBy();
    }

    @Override
    public JoiningFrag having() {
        if (!this.mergedFlag.contains(KeyFrag.HAVING)) {
            this.segments().having.add(KeyFrag.HAVING, this.wrapper.data().having());
            for (BaseQuery query : this.queries) {
                this.segments().having.add(KeyFrag.HAVING, query.data.having());
            }
            this.mergedFlag.add(KeyFrag.HAVING);
        }
        return super.groupBy();
    }

    @Override
    public JoiningFrag orderBy() {
        if (this.mergedFlag.add(KeyFrag.ORDER_BY)) {
            this.segments().orderBy.add(KeyFrag.ORDER_BY, this.wrapper.data().orderBy());
            for (BaseQuery query : this.queries) {
                this.segments().orderBy.add(KeyFrag.ORDER_BY, query.data.orderBy());
            }
            this.mergedFlag.add(KeyFrag.ORDER_BY);
        }
        return super.orderBy();
    }

    @Override
    public IFragment update() {
        throw new RuntimeException("not support!");
    }
}

