/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.segment;

import cn.org.atool.fluent.mybatis.If;
import cn.org.atool.fluent.mybatis.base.IEntity;
import cn.org.atool.fluent.mybatis.base.crud.BaseQuery;
import cn.org.atool.fluent.mybatis.base.crud.IQuery;
import cn.org.atool.fluent.mybatis.base.free.FreeKit;
import cn.org.atool.fluent.mybatis.base.free.FreeQuery;
import cn.org.atool.fluent.mybatis.base.model.FieldMapping;
import cn.org.atool.fluent.mybatis.functions.IGetter;
import cn.org.atool.fluent.mybatis.metadata.JoinType;
import cn.org.atool.fluent.mybatis.segment.BaseSegment;
import cn.org.atool.fluent.mybatis.segment.JoinQuery;
import cn.org.atool.fluent.mybatis.segment.WhereApply;
import cn.org.atool.fluent.mybatis.segment.fragment.CachedFrag;
import cn.org.atool.fluent.mybatis.segment.fragment.Column;
import cn.org.atool.fluent.mybatis.segment.fragment.IFragment;
import cn.org.atool.fluent.mybatis.segment.fragment.JoiningFrag;
import cn.org.atool.fluent.mybatis.segment.where.BaseWhere;
import cn.org.atool.fluent.mybatis.utility.MappingKits;
import cn.org.atool.fluent.mybatis.utility.MybatisUtil;
import cn.org.atool.fluent.mybatis.utility.RefKit;
import java.util.function.Function;

public class JoinOn<QL extends BaseQuery<?, QL>, QR extends BaseQuery<?, QR>, JB> {
    private final JoinQuery<QL> joinQuery;
    private final QL onLeft;
    private final JoinType joinType;
    private final QR onRight;
    private final JoiningFrag ons = JoiningFrag.get().setDelimiter(" AND ").setFilter(If::notBlank);

    public JoinOn(JoinQuery<QL> joinQuery, QL qLeft, JoinType joinType, QR qRight) {
        this.joinQuery = joinQuery;
        this.joinType = joinType;
        this.onLeft = this.emptyQuery((BaseQuery)qLeft);
        this.onRight = this.emptyQuery((BaseQuery)qRight);
    }

    private <Q extends BaseQuery> Q emptyQuery(BaseQuery origQuery) {
        BaseQuery onQuery = origQuery instanceof FreeQuery ? FreeKit.newFreeQuery(origQuery) : (BaseQuery)RefKit.byEntity(origQuery.entityClass).emptyQuery();
        onQuery.setTableAlias(origQuery::getTableAlias);
        onQuery.sharedParameter(this.joinQuery);
        return (Q)onQuery;
    }

    public JoinOn<QL, QR, JB> onApply(String condition, Object ... args) {
        String sql = this.joinQuery.data().paramSql(null, condition, args);
        this.ons.add(CachedFrag.set(sql));
        return this;
    }

    public JoinOn<QL, QR, JB> on(Function<QL, BaseWhere> l, Function<QR, BaseWhere> r) {
        this.ons.add(Column.set(this.onLeft, ((WhereApply)l.apply(this.onLeft)).current()).plus(" = ").plus(Column.set(this.onRight, ((WhereApply)r.apply(this.onRight)).current())));
        return this;
    }

    public <LE extends IEntity, RE extends IEntity> JoinOn<QL, QR, JB> onEq(IGetter<LE> l, IGetter<RE> r) {
        Class lKlass = ((BaseQuery)this.onLeft).entityClass;
        Class rKlass = ((BaseQuery)this.onRight).entityClass;
        MybatisUtil.assertNotNull("left query entity class", lKlass);
        MybatisUtil.assertNotNull("right query entity class", rKlass);
        String lField = MappingKits.toColumn(lKlass, l);
        String rField = MappingKits.toColumn(rKlass, r);
        return this.onEq(lField, rField);
    }

    public JoinOn<QL, QR, JB> onEq(String l, String r) {
        this.ons.add(Column.set(this.onLeft, l).plus(" = ").plus(Column.set(this.onRight, r)));
        return this;
    }

    public JoinOn<QL, QR, JB> onEq(FieldMapping l, FieldMapping r) {
        this.ons.add(Column.set(this.onLeft, l).plus(" = ").plus(Column.set(this.onRight, r)));
        return this;
    }

    public JoinOn<QL, QR, JB> onLeft(Function<QL, BaseSegment<?, QL>> l) {
        return this.onQuery((IQuery)this.onLeft, (Function)l);
    }

    public JoinOn<QL, QR, JB> onRight(Function<QR, BaseSegment<?, QR>> r) {
        return this.onQuery((IQuery)this.onRight, (Function)r);
    }

    private <Q extends BaseQuery<?, Q>> JoinOn onQuery(IQuery query, Function<Q, BaseSegment<?, Q>> func) {
        Q onQuery = this.emptyQuery((BaseQuery)query);
        this.ons.add(((BaseQuery)func.apply(onQuery).end()).data().where());
        return this;
    }

    public JB endJoin() {
        IFragment table = this.joinType.plus(((BaseQuery)this.onRight).data.table());
        if (!this.ons.isEmpty()) {
            table = table.plus(" ON ").plus(this.ons);
        }
        this.joinQuery.data().addTable(table);
        return (JB)this.joinQuery;
    }
}

