/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.segment;

import cn.org.atool.fluent.mybatis.If;
import cn.org.atool.fluent.mybatis.base.IEntity;
import cn.org.atool.fluent.mybatis.base.crud.IBaseQuery;
import cn.org.atool.fluent.mybatis.base.crud.IQuery;
import cn.org.atool.fluent.mybatis.base.crud.IWrapper;
import cn.org.atool.fluent.mybatis.base.entity.IMapping;
import cn.org.atool.fluent.mybatis.base.model.FieldMapping;
import cn.org.atool.fluent.mybatis.base.model.UniqueType;
import cn.org.atool.fluent.mybatis.functions.StringSupplier;
import cn.org.atool.fluent.mybatis.metadata.TableMeta;
import cn.org.atool.fluent.mybatis.metadata.TableMetaHelper;
import cn.org.atool.fluent.mybatis.segment.fragment.IFragment;
import cn.org.atool.fluent.mybatis.segment.model.Parameters;
import cn.org.atool.fluent.mybatis.segment.model.WrapperData;
import cn.org.atool.fluent.mybatis.utility.MybatisUtil;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public abstract class BaseWrapper<E extends IEntity, W extends IWrapper<E, W, NQ>, NQ extends IBaseQuery<E, NQ>>
implements IWrapper<E, W, NQ> {
    private static final long serialVersionUID = 2674302532927710150L;
    protected IFragment table;
    private StringSupplier tableAlias;
    protected WrapperData data;
    protected Class entityClass;

    @Override
    public String getTableAlias() {
        return this.tableAlias == null ? null : (String)this.tableAlias.get();
    }

    protected void setTableAlias(StringSupplier tableAlias) {
        this.tableAlias = tableAlias;
    }

    protected void setTableAlias(String tableAlias) {
        this.tableAlias = () -> If.isBlank(tableAlias) ? "" : tableAlias.trim();
    }

    protected BaseWrapper(String tableAlias) {
        this.setTableAlias(tableAlias);
    }

    protected BaseWrapper(StringSupplier tableAlias) {
        this.setTableAlias(tableAlias);
    }

    protected BaseWrapper(IFragment table, StringSupplier tableAlias, Class<E> entityClass) {
        this(table, tableAlias, new Parameters(), entityClass);
    }

    protected BaseWrapper(IFragment table, StringSupplier tableAlias, Parameters parameters, Class<E> entityClass) {
        MybatisUtil.notNull(entityClass, "entityClass must not null,please set entity before use this method!", new Object[0]);
        this.table = table;
        this.setTableAlias(tableAlias);
        this.data = new WrapperData(this, parameters);
        this.entityClass = entityClass;
    }

    @Override
    public Optional<IMapping> mapping() {
        return Optional.empty();
    }

    @Override
    public IFragment table(boolean notFoundError) {
        if (this.table != null && this.table.notEmpty()) {
            return this.table;
        }
        if (notFoundError) {
            return this.mapping().map(IMapping::table).orElseThrow(() -> new RuntimeException("table name not found."));
        }
        return this.mapping().map(IMapping::table).orElse(null);
    }

    public String fieldName(UniqueType type) {
        return this.mapping().flatMap(m -> m.findField(type)).map(c -> c.column).orElse(null);
    }

    @Override
    public List<String> allFields() {
        return this.mapping().map(IMapping::getAllColumns).orElse(Collections.emptyList());
    }

    @Override
    public WrapperData data() {
        return this.data;
    }

    protected TableMeta getTableMeta() {
        return TableMetaHelper.getTableInfo(this.entityClass);
    }

    protected void sharedParameter(Parameters parameters) {
        this.data.getParameters().sharedParameter(parameters);
    }

    protected void sharedParameter(BaseWrapper wrapper) {
        this.data.getParameters().sharedParameter(wrapper.data().getParameters());
    }

    public FieldMapping column(String column) {
        return this.column2mapping().get(column);
    }

    protected IQuery union(String key, IQuery ... queries) {
        if (this.data.paged() != null) {
            throw new RuntimeException("Limit syntax is not supported for union queries.");
        }
        if (queries == null || queries.length == 0) {
            throw new IllegalArgumentException("The size of parameter[queries] should be greater than zero.");
        }
        for (IQuery query : queries) {
            this.data.union(key, query);
            query.data().sharedParameter(this.data);
        }
        return (IQuery)((Object)this);
    }

    private Map<String, FieldMapping> column2mapping() {
        return this.mapping().map(IMapping::getColumnMap).orElse(Collections.EMPTY_MAP);
    }

    public Class getEntityClass() {
        return this.entityClass;
    }
}

