/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.metadata;

import cn.org.atool.fluent.mybatis.base.model.KeyMap;
import cn.org.atool.fluent.mybatis.utility.LockKit;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

public class GetterMeta {
    public final String fieldName;
    private final Method method;
    public final Type fType;
    private static final KeyMap<KeyMap<GetterMeta>> methodMetas = new KeyMap();
    private static final LockKit<Class> ClassLock = new LockKit(16);

    private GetterMeta(Method method) {
        this.method = method;
        String name = method.getName();
        this.fieldName = name.startsWith("is") ? name.substring(2, 3).toLowerCase() + name.substring(3) : name.substring(3, 4).toLowerCase() + name.substring(4);
        this.fType = method.getGenericReturnType();
    }

    public Object getValue(Object target) throws InvocationTargetException, IllegalAccessException {
        return target == null ? null : this.method.invoke(target, new Object[0]);
    }

    public static GetterMeta get(Class klass, String fieldName) {
        if (!methodMetas.containsKey(klass)) {
            GetterMeta.buildMetas(klass);
        }
        return methodMetas.get(klass).get(fieldName);
    }

    public static KeyMap<GetterMeta> get(Class klass) {
        if (!methodMetas.containsKey(klass)) {
            GetterMeta.buildMetas(klass);
        }
        return methodMetas.get(klass);
    }

    private static void buildMetas(Class klass) {
        ClassLock.lockDoing(methodMetas::containsKey, klass, () -> {
            Method[] methods = klass.getDeclaredMethods();
            KeyMap<GetterMeta> classMethods = new KeyMap<GetterMeta>();
            for (Method m : methods) {
                String name = m.getName();
                if (!name.startsWith("get") && !name.startsWith("is") || m.getParameterCount() != 0) continue;
                m.setAccessible(true);
                GetterMeta meta = new GetterMeta(m);
                classMethods.put(meta.fieldName, meta);
            }
            methodMetas.put(klass, classMethods);
        });
    }
}

