/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.metadata;

import cn.org.atool.fluent.mybatis.If;
import cn.org.atool.fluent.mybatis.utility.MybatisUtil;
import java.lang.reflect.Field;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.TypeHandler;

public abstract class FieldMeta
implements Comparable<FieldMeta> {
    protected final String column;
    protected final String property;
    protected final Class<?> propertyType;
    private JdbcType jdbcType;
    protected Class<? extends TypeHandler<?>> typeHandler;
    protected String el;

    public FieldMeta(String column, Field field) {
        this.property = field.getName();
        this.column = If.isBlank(column) ? MybatisUtil.camelToUnderline(this.property, false) : column;
        this.propertyType = field.getType();
    }

    public void setJdbcType(JdbcType jdbcType) {
        this.jdbcType = JdbcType.UNDEFINED == jdbcType ? null : jdbcType;
    }

    protected String el() {
        String el = this.property;
        if (this.jdbcType != null) {
            el = el + ", jdbcType = " + this.jdbcType.name();
        }
        if (this.typeHandler != null) {
            el = el + ", typeHandler = " + this.typeHandler.getName();
        }
        return el;
    }

    public boolean isNotLarge() {
        return true;
    }

    @Override
    public int compareTo(FieldMeta o) {
        return this.column.compareTo(o.getColumn());
    }

    public String getColumn() {
        return this.column;
    }

    public String getProperty() {
        return this.property;
    }

    public Class<?> getPropertyType() {
        return this.propertyType;
    }

    public JdbcType getJdbcType() {
        return this.jdbcType;
    }

    public Class<? extends TypeHandler<?>> getTypeHandler() {
        return this.typeHandler;
    }

    public String getEl() {
        return this.el;
    }
}

