/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.mapper;

import cn.org.atool.fluent.mybatis.If;
import cn.org.atool.fluent.mybatis.base.IEntity;
import cn.org.atool.fluent.mybatis.base.crud.IQuery;
import cn.org.atool.fluent.mybatis.base.crud.IUpdate;
import cn.org.atool.fluent.mybatis.base.entity.IMapping;
import cn.org.atool.fluent.mybatis.base.intf.BatchCrud;
import cn.org.atool.fluent.mybatis.base.mapper.IEntityMapper;
import cn.org.atool.fluent.mybatis.base.mapper.IWrapperMapper;
import cn.org.atool.fluent.mybatis.base.provider.SqlProvider;
import cn.org.atool.fluent.mybatis.utility.RefKit;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.ibatis.builder.annotation.ProviderContext;
import org.apache.ibatis.builder.annotation.ProviderContextKit;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.ParameterMode;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.scripting.defaults.RawSqlSource;
import org.apache.ibatis.scripting.xmltags.SqlNode;
import org.apache.ibatis.scripting.xmltags.TextSqlNode;
import org.apache.ibatis.session.Configuration;

public class PrinterMapper
implements IWrapperMapper {
    private static Configuration configuration = new Configuration();
    private static final ThreadLocal<PrinterMapper> local = new ThreadLocal();
    private IMapping mapping;
    private Class<? extends IWrapperMapper> mapperClass;
    private final int mode;
    private final List<String> sql = new ArrayList<String>();
    private static Map<String, Method> methods = null;

    private PrinterMapper(int mode, IMapping mapping) {
        this.mode = mode;
        this.mapping(mapping);
    }

    public static boolean isPrint() {
        return local.get() != null;
    }

    @Override
    public int insert(IEntity entity) {
        return this.simulate("insert", this.map("ew", entity), SqlProvider::insert);
    }

    @Override
    public int insertBatch(Collection entities) {
        return this.simulate("insertBatch", this.map("list", entities), SqlProvider::insertBatch);
    }

    @Override
    public int insertWithPk(IEntity entity) {
        return this.simulate("insertWithPk", this.map("ew", entity), SqlProvider::insertWithPk);
    }

    @Override
    public int insertBatchWithPk(Collection entities) {
        return this.simulate("insertBatchWithPk", this.map("list", entities), SqlProvider::insertBatchWithPk);
    }

    @Override
    public int insertSelect(String[] fields, IQuery query) {
        Map<String, Object> map = this.map("ew", query, "fields", fields);
        return this.simulate("insertSelect", map, SqlProvider::insertSelect);
    }

    @Override
    public int updateBy(IUpdate ... updates) {
        return this.simulate("updateBy", this.map("ew", updates), SqlProvider::updateBy);
    }

    @Override
    public List internalListEntity(IQuery query) {
        this.simulate("listEntity", this.map("ew", query), SqlProvider::listEntity);
        return Collections.emptyList();
    }

    @Override
    public List<Map<String, Object>> listMaps(IQuery query) {
        this.simulate("listMaps", this.map("ew", query), SqlProvider::listMaps);
        return Collections.emptyList();
    }

    @Override
    public List listObjs(IQuery query) {
        this.simulate("listObjs", this.map("ew", query), SqlProvider::listObjs);
        return Collections.emptyList();
    }

    @Override
    public int count(IQuery query) {
        return this.simulate("count", this.map("ew", query), SqlProvider::count);
    }

    @Override
    public int countNoLimit(IQuery query) {
        return this.simulate("countNoLimit", this.map("ew", query), SqlProvider::countNoLimit);
    }

    @Override
    public int delete(IQuery query) {
        return this.simulate("delete", this.map("ew", query), SqlProvider::delete);
    }

    @Override
    public void batchCrud(BatchCrud crud) {
        this.simulate("batchCrud", this.map("ew", crud), SqlProvider::batchCrud);
    }

    @Override
    public void callProcedure(String procedure, Object parameter) {
        this.addSQL(parameter, () -> "{CALL " + procedure + "}");
    }

    @Override
    public IMapping mapping() {
        return this.mapping;
    }

    private int simulate(String method, Map map, BiFunction<Map, ProviderContext, String> simulator) {
        ProviderContext context = ProviderContextKit.newProviderContext(this.mapperClass, this.method(method));
        this.addSQL(map, () -> (String)simulator.apply(map, context));
        return 1;
    }

    private Map<String, Object> map(Object ... kvs) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (int index = 1; index < kvs.length; index += 2) {
            map.put((String)kvs[index - 1], kvs[index]);
        }
        return map;
    }

    private Method method(String methodName) {
        if (methods == null) {
            methods = new HashMap<String, Method>(16);
            for (Method m : IEntityMapper.class.getDeclaredMethods()) {
                methods.put(m.getName(), m);
            }
        }
        return methods.get(methodName);
    }

    private <P> void addSQL(P object, Supplier<String> supplier) {
        String text = supplier.get();
        if (If.isBlank(text) || this.mode == 2) {
            this.sql.add(text);
            return;
        }
        TextSqlNode textSqlNode = new TextSqlNode(text);
        RawSqlSource sqlSource = new RawSqlSource(configuration, (SqlNode)textSqlNode, object.getClass());
        BoundSql boundSql = sqlSource.getBoundSql(object);
        if (this.mode == 0) {
            this.sql.add(boundSql.getSql());
            return;
        }
        Map<String, Object> parameters = this.getParameters(boundSql);
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            String expression = "#{" + entry.getKey() + "}";
            Object value = entry.getValue();
            text = this.replaceBy(text, expression, value);
        }
        this.sql.add(text);
    }

    private String replaceBy(String text, String expression, Object value) {
        text = value == null ? text.replace(expression, "null") : (value.getClass().isPrimitive() || value instanceof Number || value instanceof Boolean ? text.replace(expression, String.valueOf(value)) : text.replace(expression, "'" + value + "'"));
        return text;
    }

    private Map<String, Object> getParameters(BoundSql boundSql) {
        HashMap<String, Object> values = new HashMap<String, Object>();
        for (ParameterMapping pm : boundSql.getParameterMappings()) {
            if (pm.getMode() == ParameterMode.OUT) continue;
            values.put(pm.getProperty(), this.parseParameterValue(boundSql, pm));
        }
        return values;
    }

    private Object parseParameterValue(BoundSql boundSql, ParameterMapping pm) {
        Object parameterObject = boundSql.getParameterObject();
        String property = pm.getProperty();
        if (boundSql.hasAdditionalParameter(property)) {
            return boundSql.getAdditionalParameter(property);
        }
        if (parameterObject == null) {
            return null;
        }
        if (configuration.getTypeHandlerRegistry().hasTypeHandler(parameterObject.getClass())) {
            return parameterObject;
        }
        MetaObject metaObject = configuration.newMetaObject(parameterObject);
        return metaObject.getValue(property);
    }

    public static IWrapperMapper set(int mode, IMapping mapping) {
        local.set(new PrinterMapper(mode, mapping));
        return local.get();
    }

    public static void clear() {
        local.remove();
    }

    public static IWrapperMapper get(IWrapperMapper mapper, Class eClass) {
        if (local.get() == null) {
            return mapper;
        }
        local.get().mapping(RefKit.byEntity(eClass));
        return local.get();
    }

    private void mapping(IMapping mapping) {
        this.mapping = mapping;
        this.mapperClass = mapping.mapperClass();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> print(int mode, IMapping mapping, Consumer<IWrapperMapper> ... simulators) {
        try {
            PrinterMapper mapper = (PrinterMapper)PrinterMapper.set(mode, mapping);
            for (Consumer<IWrapperMapper> simulator : simulators) {
                simulator.accept(mapper);
            }
            List<String> list = mapper.getSql();
            return list;
        }
        finally {
            PrinterMapper.clear();
        }
    }

    public static void setConfiguration(Configuration configuration) {
        PrinterMapper.configuration = configuration;
    }

    public List<String> getSql() {
        return this.sql;
    }
}

