/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.mapper;

import cn.org.atool.fluent.mybatis.If;
import cn.org.atool.fluent.mybatis.base.entity.IMapping;
import cn.org.atool.fluent.mybatis.metadata.DbType;
import cn.org.atool.fluent.mybatis.segment.fragment.IFragment;
import cn.org.atool.fluent.mybatis.segment.fragment.JoiningFrag;
import cn.org.atool.fluent.mybatis.segment.fragment.KeyFrag;
import cn.org.atool.fluent.mybatis.segment.model.HintType;
import cn.org.atool.fluent.mybatis.segment.model.WrapperData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;

public class MapperSql {
    private final List<String> text = new ArrayList<String>();
    static final AtomicLong tmp = new AtomicLong(0L);

    public String toString() {
        return this.text.stream().map(String::trim).filter(If::notBlank).collect(Collectors.joining(" "));
    }

    public MapperSql SELECT(String table, String columns) {
        this.add(KeyFrag.SELECT.key(), columns, KeyFrag.FROM.key(), table);
        return this;
    }

    private void add(String ... objects) {
        this.text.addAll(Arrays.asList(objects));
    }

    public MapperSql COUNT(IMapping mapping, IFragment table, WrapperData data) {
        this.add(data.hint(HintType.Before_All), KeyFrag.SELECT.key(), data.hint(HintType.After_CrudKey), "COUNT(*)", KeyFrag.FROM.key(), data.hint(HintType.Before_Table), table.get(mapping), data.hint(HintType.After_Table));
        return this;
    }

    public MapperSql INSERT_INTO(String table) {
        this.add(KeyFrag.INSERT_INTO.key(), table);
        return this;
    }

    public MapperSql VALUES() {
        this.add("VALUES");
        return this;
    }

    public MapperSql INSERT_COLUMNS(IMapping mapping, List<String> columns) {
        String joining = columns.stream().map(String::trim).map(arg_0 -> ((DbType)mapping.db()).wrap(arg_0)).collect(Collectors.joining(", "));
        this.add(MapperSql.brackets(joining));
        return this;
    }

    public MapperSql DELETE_FROM(IMapping mapping, IFragment table, WrapperData data) {
        this.add(data.hint(HintType.Before_All), KeyFrag.DELETE.key(), data.hint(HintType.After_CrudKey), KeyFrag.FROM.key(), data.hint(HintType.Before_Table), table.get(mapping), data.hint(HintType.After_Table));
        return this;
    }

    public MapperSql UPDATE(IMapping mapping, IFragment table) {
        this.add(KeyFrag.UPDATE.key(), table.get(mapping));
        return this;
    }

    public MapperSql UPDATE(IMapping mapping, IFragment table, WrapperData data) {
        this.add(data.hint(HintType.Before_All), KeyFrag.UPDATE.key(), data.hint(HintType.After_CrudKey), data.hint(HintType.Before_Table), table.get(mapping), data.hint(HintType.After_Table));
        return this;
    }

    public MapperSql SET(String ... sets) {
        this.add(KeyFrag.SET.key(), String.join((CharSequence)", ", sets));
        return this;
    }

    public MapperSql SET(IMapping mapping, JoiningFrag sets) {
        this.add(KeyFrag.SET.key(), sets.get(mapping));
        return this;
    }

    public MapperSql WHERE(String where) {
        if (If.notBlank(where)) {
            this.add(KeyFrag.WHERE.key(), where);
        }
        return this;
    }

    public MapperSql WHERE(List<String> where) {
        if (!where.isEmpty()) {
            this.add(KeyFrag.WHERE.key(), String.join((CharSequence)" AND ", where));
        }
        return this;
    }

    public MapperSql WHERE(DbType dbType, String prefix, Map<String, Object> where) {
        ArrayList<String> ands = new ArrayList<String>();
        for (Map.Entry<String, Object> entry : where.entrySet()) {
            if (entry.getValue() == null) {
                ands.add(dbType.wrap(entry.getKey()) + " IS NULL");
                continue;
            }
            String column = entry.getKey();
            String el = dbType.wrap(column) + " = #{" + (If.isBlank(prefix) ? column : prefix + "." + column) + "}";
            ands.add(el);
        }
        return this.WHERE(ands);
    }

    public MapperSql WHERE_GROUP_BY(IMapping mapping, WrapperData data) {
        this.WHERE_GROUP_HAVING(mapping, data);
        if (data.last().notEmpty()) {
            this.APPEND(data.segments().last());
        }
        return this;
    }

    public MapperSql WHERE_GROUP_ORDER_BY(IMapping mapping, WrapperData data) {
        this.WHERE_GROUP_HAVING(mapping, data);
        if (data.orderBy().notEmpty()) {
            this.APPEND(data.segments().orderBy.get(mapping));
        }
        if (data.last().notEmpty()) {
            this.APPEND(data.segments().last());
        }
        return this;
    }

    private void WHERE_GROUP_HAVING(IMapping mapping, WrapperData data) {
        if (data.where().notEmpty()) {
            this.WHERE(data.segments().where.get(mapping));
        }
        if (data.groupBy().notEmpty()) {
            this.APPEND(data.segments().groupBy.get(mapping));
        }
        if (data.having().notEmpty()) {
            this.APPEND(data.segments().having.get(mapping));
        }
    }

    public MapperSql APPEND(String sql) {
        this.add(sql);
        return this;
    }

    public MapperSql SELECT(IMapping mapping, IFragment table, WrapperData data, IFragment defaultColumns) {
        String select = data.select().get(mapping);
        this.add(data.hint(HintType.Before_All), KeyFrag.SELECT.key(), data.hint(HintType.After_CrudKey), data.isDistinct() ? KeyFrag.DISTINCT.key() : "", If.isBlank(select) ? defaultColumns.get(mapping) : select, KeyFrag.FROM.key(), data.hint(HintType.Before_Table), table.get(mapping), data.hint(HintType.After_Table));
        return this;
    }

    public MapperSql LIMIT(WrapperData data, boolean offsetEverZero) {
        if (data == null || data.paged() == null) {
            return this;
        }
        if (offsetEverZero) {
            this.add("LIMIT #{ew.data.paged.limit}");
        } else {
            this.add("LIMIT #{ew.data.paged.offset}, #{ew.data.paged.limit}");
        }
        return this;
    }

    public static String brackets(Object obj) {
        return obj == null ? "()" : "(" + String.valueOf(obj).trim() + ")";
    }

    public static String brackets(String delimiter, List<String> list) {
        return "(" + String.join((CharSequence)", ", list) + ")";
    }

    public static String tmpTable() {
        return "TMP_" + tmp.incrementAndGet();
    }
}

