/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.base.provider;

import cn.org.atool.fluent.mybatis.base.intf.IHasDbType;
import cn.org.atool.fluent.mybatis.base.intf.IHasMapping;
import cn.org.atool.fluent.mybatis.base.provider.CommonSqlKit;
import cn.org.atool.fluent.mybatis.base.provider.OracleSqlKit;
import cn.org.atool.fluent.mybatis.base.provider.SqlKit;
import cn.org.atool.fluent.mybatis.metadata.DbType;
import java.util.HashMap;
import java.util.Map;

public class SqlKitFactory {
    private static SqlKitFactory DEFAULT_FACTORY = new SqlKitFactory();
    protected final Map<DbType, SqlKit> kits = new HashMap<DbType, SqlKit>(8);

    public static SqlKit factory(DbType dbType) {
        return DEFAULT_FACTORY.sqlKit(dbType);
    }

    public static SqlKit factory(IHasMapping obj) {
        return SqlKitFactory.factory(obj.mapping());
    }

    public static SqlKit factory(IHasDbType mapping) {
        return SqlKitFactory.factory(mapping.db());
    }

    protected SqlKitFactory() {
    }

    public static void setFactory(SqlKitFactory factory) {
        DEFAULT_FACTORY = factory;
    }

    public SqlKit sqlKit(DbType dbType) {
        SqlKit kit = this.kits.get(dbType);
        return kit == null ? this.newSqlKit(dbType) : kit;
    }

    private synchronized SqlKit newSqlKit(DbType dbType) {
        if (this.kits.containsKey(dbType)) {
            return this.kits.get(dbType);
        }
        switch (dbType) {
            case ORACLE: 
            case ORACLE12: {
                this.kits.put(dbType, new OracleSqlKit());
                break;
            }
            default: {
                this.kits.put(dbType, new CommonSqlKit());
            }
        }
        return this.kits.get(dbType);
    }
}

