/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.base.mapper;

import cn.org.atool.fluent.mybatis.If;
import cn.org.atool.fluent.mybatis.base.IEntity;
import cn.org.atool.fluent.mybatis.base.crud.IBaseQuery;
import cn.org.atool.fluent.mybatis.base.crud.IQuery;
import cn.org.atool.fluent.mybatis.base.crud.IUpdate;
import cn.org.atool.fluent.mybatis.base.crud.IWrapper;
import cn.org.atool.fluent.mybatis.base.entity.PkGeneratorKits;
import cn.org.atool.fluent.mybatis.base.mapper.IEntityMapper;
import cn.org.atool.fluent.mybatis.base.mapper.IWrapperMapper;
import cn.org.atool.fluent.mybatis.base.model.FieldMapping;
import cn.org.atool.fluent.mybatis.base.model.ISqlOp;
import cn.org.atool.fluent.mybatis.base.model.SqlOp;
import cn.org.atool.fluent.mybatis.base.provider.SqlKitFactory;
import cn.org.atool.fluent.mybatis.exception.FluentMybatisException;
import cn.org.atool.fluent.mybatis.functions.MapFunction;
import cn.org.atool.fluent.mybatis.model.StdPagedList;
import cn.org.atool.fluent.mybatis.model.TagPagedList;
import cn.org.atool.fluent.mybatis.segment.BaseSegment;
import cn.org.atool.fluent.mybatis.utility.MybatisUtil;
import cn.org.atool.fluent.mybatis.utility.PoJoHelper;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.NonNull;

public interface IRichMapper<E extends IEntity>
extends IEntityMapper<E> {
    default public int updateById(E entity) {
        IUpdate update = SqlKitFactory.factory(this).updateById(this.mapping(), (IEntity)entity);
        return this.updateBy(update);
    }

    default public E findById(Object id) {
        IQuery query = SqlKitFactory.factory(this).queryByIds(this.mapping(), new Object[]{id});
        return this.findOne(query);
    }

    default public E findOne(IQuery query) {
        List list = this.listEntity(query);
        if (If.isEmpty(list)) {
            return null;
        }
        if (list.size() == 1) {
            return (E)((IEntity)list.get(0));
        }
        throw new FluentMybatisException("Expected one result (or null) to be returned, but found " + list.size() + " results.");
    }

    default public List<E> listByIds(Object ... ids) {
        IQuery query = SqlKitFactory.factory(this).queryByIds(this.mapping(), ids);
        return this.listEntity(query);
    }

    default public List<E> listByIds(Collection ids) {
        IQuery query = SqlKitFactory.factory(this).queryByIds(this.mapping(), ids);
        return this.listEntity(query);
    }

    default public List<E> listByMap(boolean isColumn, Map<String, Object> condition) {
        MybatisUtil.assertNotEmpty("condition", condition);
        Object query = this.mapping().query();
        SqlKitFactory.factory(this).eqByMap(this.mapping(), (IWrapper)query, isColumn, condition);
        return this.listEntity((IQuery)query);
    }

    default public int deleteById(Object ... ids) {
        MybatisUtil.assertNotEmpty("ids", ids);
        IQuery query = SqlKitFactory.factory(this).queryByIds(this.mapping(), ids);
        return this.delete(query);
    }

    default public int deleteByIds(Collection ids) {
        MybatisUtil.assertNotEmpty("ids", ids);
        IQuery query = SqlKitFactory.factory(this).queryByIds(this.mapping(), ids);
        return this.delete(query);
    }

    default public int deleteByMap(boolean isColumn, Map<String, Object> condition) {
        Object query = this.mapping().query();
        SqlKitFactory.factory(this).eqByMap(this.mapping(), (IWrapper)query, isColumn, condition);
        return this.delete((IQuery)query);
    }

    default public int logicDeleteById(Object ... ids) {
        MybatisUtil.assertNotEmpty("ids", ids);
        IUpdate update = SqlKitFactory.factory(this).logicDeleteByIds(this.mapping(), ids);
        return this.updateBy(update);
    }

    default public int logicDeleteByIds(Collection ids) {
        MybatisUtil.assertNotEmpty("ids", ids);
        IUpdate update = SqlKitFactory.factory(this).logicDeleteByIds(this.mapping(), ids);
        return this.updateBy(update);
    }

    default public int logicDeleteByMap(boolean isColumn, Map<String, Object> condition) {
        MybatisUtil.assertNotEmpty("ids", condition);
        Object update = this.mapping().updater();
        update.data().setIgnoreLockVersion(true);
        SqlKitFactory.factory(this).setLogicDeleted(this.mapping(), (IUpdate)update);
        SqlKitFactory.factory(this).eqByMap(this.mapping(), (IWrapper)update, isColumn, condition);
        return this.updateBy(new IUpdate[]{update});
    }

    default public int logicDelete(IQuery query) {
        MybatisUtil.assertNotNull("query", query);
        query.data().setIgnoreLockVersion(true);
        IUpdate update = SqlKitFactory.factory(this).logicDeleteBy(this.mapping(), query);
        return this.updateBy(update);
    }

    default public boolean existPk(Object id) {
        IBaseQuery query = (IBaseQuery)((IWrapperMapper)this).emptyQuery();
        FieldMapping pk = ((IWrapperMapper)this).primaryField();
        ((IBaseQuery)((BaseSegment)query.where().apply(pk.column, (ISqlOp)SqlOp.EQ, id)).end()).limit(1);
        int count = this.count(query);
        return count > 0;
    }

    default public boolean saveOrUpdate(E entity) {
        if (entity.findPk() == null) {
            return this.insert(entity) > 0;
        }
        if (this.existPk(entity.findPk())) {
            return this.updateById(entity) > 0;
        }
        return this.insertWithPk(entity) > 0;
    }

    default public <PK> PK save(E entity) {
        PkGeneratorKits.setPkByGenerator(entity);
        if (entity.findPk() == null) {
            this.insert(entity);
        } else {
            this.insertWithPk(entity);
        }
        return (PK)entity.findPk();
    }

    default public int save(Collection<E> list) {
        boolean hasPk = false;
        for (IEntity entity : list) {
            if (entity.findPk() == null) continue;
            hasPk = true;
            break;
        }
        if (hasPk) {
            return this.insertBatchWithPk(list);
        }
        return this.insertBatch(list);
    }

    default public <POJO> Optional<POJO> findOne(IQuery query, MapFunction<POJO> mapFunction) {
        Optional<Map<String, Object>> optional = this.findOneMap(query);
        return optional.map(m -> PoJoHelper.toPoJo(m, mapFunction));
    }

    default public <POJO> Optional<POJO> findOne(Class<POJO> clazz, IQuery query) {
        Optional<Map<String, Object>> optional = this.findOneMap(query);
        return optional.map(m -> PoJoHelper.toPoJo(clazz, m));
    }

    default public Optional<Map<String, Object>> findOneMap(IQuery query) {
        List<Map<String, Object>> list = this.listMaps(query);
        if (list != null && list.size() > 1) {
            throw new RuntimeException("The expected result is one, but the returned result is multiple.");
        }
        Map<String, Object> map = list == null || list.size() == 0 ? null : list.get(0);
        return Optional.ofNullable(map);
    }

    default public <POJO> List<POJO> listPoJos(IQuery query, MapFunction<POJO> mapFunction) {
        List<Map<String, Object>> list = this.listMaps(query);
        return PoJoHelper.toPoJoList(list, mapFunction);
    }

    default public <POJO> List<POJO> listPoJos(Class<POJO> clazz, IQuery query) {
        List<Map<String, Object>> list = this.listMaps(query);
        return PoJoHelper.toPoJoList(clazz, list);
    }

    default public List<E> listByMapAndDefault(Map<String, Object> where) {
        IQuery query = (IQuery)((BaseSegment)((IWrapperMapper)this).query().where().eqNotNull(where)).end();
        return this.listEntity(query);
    }

    default public StdPagedList<E> stdPagedEntity(IQuery query) {
        int total = this.countNoLimit(query);
        List<Object> list = total == 0 ? Collections.emptyList() : this.listEntity(query);
        return new StdPagedList(total, list, query.data().hasNext(total));
    }

    default public StdPagedList<Map<String, Object>> stdPagedMap(IQuery query) {
        int total = this.countNoLimit(query);
        List<Object> list = total == 0 ? Collections.emptyList() : this.listMaps(query);
        return new StdPagedList<Map<String, Object>>(total, list, query.data().hasNext(total));
    }

    default public <POJO> StdPagedList<POJO> stdPagedPoJo(IQuery query, @NonNull MapFunction<POJO> mapFunction) {
        if (mapFunction == null) {
            throw new NullPointerException("mapFunction is marked non-null but is null");
        }
        StdPagedList<Map<String, Object>> paged = this.stdPagedMap(query);
        if (paged == null || paged.getData() == null) {
            return paged;
        }
        List<POJO> list = PoJoHelper.toPoJoList(paged.getData(), mapFunction);
        return new StdPagedList<POJO>(paged.getTotal(), list, paged.hasNext());
    }

    default public <POJO> StdPagedList<POJO> stdPagedPoJo(Class<POJO> clazz, IQuery query) {
        StdPagedList<Map<String, Object>> paged = this.stdPagedMap(query);
        List<POJO> list = PoJoHelper.toPoJoList(clazz, paged.getData());
        return new StdPagedList<POJO>(paged.getTotal(), list, paged.hasNext());
    }

    default public TagPagedList<E> tagPagedEntity(IQuery query) {
        int size = PoJoHelper.validateTagPaged(query);
        query.limit(size + 1);
        List list = this.listEntity(query);
        IEntity next = null;
        if (list.size() > size) {
            next = (IEntity)list.remove(size);
        }
        return new TagPagedList<IEntity>(list, next);
    }

    default public TagPagedList<Map<String, Object>> tagPagedMap(IQuery query) {
        int size = PoJoHelper.validateTagPaged(query);
        query.limit(size + 1);
        List<Map<String, Object>> list = this.listMaps(query);
        Map<String, Object> next = null;
        if (list.size() > size) {
            next = list.remove(size);
        }
        return new TagPagedList<Map<String, Object>>(list, next);
    }

    default public <POJO> TagPagedList<POJO> tagPagedPoJo(IQuery query, MapFunction<POJO> mapFunction) {
        TagPagedList<Map<String, Object>> paged = this.tagPagedMap(query);
        List<POJO> list = PoJoHelper.toPoJoList(paged.getData(), mapFunction);
        Object next = PoJoHelper.toPoJo((Map)paged.getNext(), mapFunction);
        return new TagPagedList<POJO>(list, next);
    }

    default public <POJO> TagPagedList<POJO> tagPagedPoJo(Class<POJO> clazz, IQuery query) {
        TagPagedList<Map<String, Object>> paged = this.tagPagedMap(query);
        List<POJO> list = PoJoHelper.toPoJoList(clazz, paged.getData());
        POJO next = PoJoHelper.toPoJo(clazz, (Map)paged.getNext());
        return new TagPagedList<POJO>(list, next);
    }

    default public int deleteByMapAndDefault(Map<String, Object> where) {
        IQuery query = (IQuery)((BaseSegment)((IWrapperMapper)this).query().where().eqNotNull(where)).end();
        return this.delete(query);
    }

    default public int logicDeleteByMapAndDefault(Map<String, Object> where) {
        IQuery query = (IQuery)((BaseSegment)((IWrapperMapper)this).query().where().eqNotNull(where)).end();
        return this.logicDelete(query);
    }

    default public int deleteByEntityIds(Collection<E> entities) {
        List ids = entities.stream().map(IEntity::findPk).collect(Collectors.toList());
        return this.deleteByIds(ids);
    }

    default public int logicDeleteByEntityIds(Collection<E> entities) {
        List ids = entities.stream().map(IEntity::findPk).collect(Collectors.toList());
        return this.logicDeleteByIds(ids);
    }

    default public int deleteByEntityIds(E ... entities) {
        return this.deleteByEntityIds(Arrays.asList(entities));
    }

    default public int logicDeleteByEntityIds(E ... entities) {
        return this.logicDeleteByEntityIds(Arrays.asList(entities));
    }
}

