/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.base.entity;

import cn.org.atool.fluent.mybatis.If;
import cn.org.atool.fluent.mybatis.base.IEntity;
import cn.org.atool.fluent.mybatis.base.crud.BaseDefaults;
import cn.org.atool.fluent.mybatis.base.crud.IQuery;
import cn.org.atool.fluent.mybatis.base.crud.IUpdate;
import cn.org.atool.fluent.mybatis.base.crud.IWrapper;
import cn.org.atool.fluent.mybatis.base.entity.IEntityKit;
import cn.org.atool.fluent.mybatis.base.entity.IMapping;
import cn.org.atool.fluent.mybatis.base.entity.TableId;
import cn.org.atool.fluent.mybatis.base.model.FieldMapping;
import cn.org.atool.fluent.mybatis.base.model.KeyMap;
import cn.org.atool.fluent.mybatis.base.model.UniqueType;
import cn.org.atool.fluent.mybatis.functions.IGetter;
import cn.org.atool.fluent.mybatis.functions.RefKey;
import cn.org.atool.fluent.mybatis.functions.RefKeyFunc;
import cn.org.atool.fluent.mybatis.functions.TableDynamic;
import cn.org.atool.fluent.mybatis.metadata.DbType;
import cn.org.atool.fluent.mybatis.segment.fragment.CachedFrag;
import cn.org.atool.fluent.mybatis.segment.fragment.IFragment;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public abstract class AMapping<E extends IEntity, Q extends IQuery<E>, U extends IUpdate<E>>
extends BaseDefaults<E, Q, U>
implements IMapping,
IEntityKit {
    protected String schema;
    protected String tableName;
    private TableDynamic tableSupplier;
    private DbType dbType;
    public final Map<String, FieldMapping> columnMap;
    public final Map<String, FieldMapping> fieldsMap;
    public final List<String> allFields;
    public final List<String> allColumns;
    public final CachedFrag selectAll;
    protected Map<UniqueType, FieldMapping> uniqueFields = new HashMap<UniqueType, FieldMapping>(4);
    private final CachedFrag tableSegment = CachedFrag.set(m -> {
        DbType db = m.db();
        if (NeedSchemaDb.contains(db) && If.notBlank(this.schema)) {
            return this.schema + "." + db.wrap(this.tableName);
        }
        return db.wrap(this.tableName);
    });
    static final List<DbType> NeedSchemaDb = Arrays.asList(DbType.DERBY, DbType.POSTGRE_SQL, DbType.SQL_SERVER2012, DbType.SQL_SERVER2005);
    protected TableId tableId = null;
    protected final KeyMap<RefKey> Ref_Keys = new KeyMap();

    protected AMapping(DbType dbType) {
        this.dbType = dbType;
        this.columnMap = this.allFields().stream().collect(Collectors.toMap(f -> f.column, f -> f));
        this.fieldsMap = this.allFields().stream().collect(Collectors.toMap(f -> f.name, f -> f));
        this.allColumns = Collections.unmodifiableList(this.allFields().stream().map(f -> f.column).collect(Collectors.toList()));
        this.selectAll = CachedFrag.set(m -> this.allColumns.stream().map(arg_0 -> ((DbType)m.db()).wrap(arg_0)).collect(Collectors.joining(", ")));
        this.allFields = Collections.unmodifiableList(this.allFields().stream().map(f -> f.name).collect(Collectors.toList()));
    }

    @Override
    public abstract List<FieldMapping> allFields();

    @Override
    public String columnOfField(String field) {
        if (this.fieldsMap.containsKey(field)) {
            return this.fieldsMap.get((Object)field).column;
        }
        return null;
    }

    public <T extends IEntity> T toEntity(Map<String, Object> map) {
        Object entity = this.newEntity();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            FieldMapping f = this.fieldsMap.get(entry.getKey());
            if (f == null) continue;
            f.setter.set(entity, entry.getValue());
        }
        return (T)entity;
    }

    private Map<String, Object> toMap(IEntity entity, boolean isProperty, boolean allowedNull) {
        HashMap<String, Object> map = new HashMap<String, Object>(this.allFields.size());
        if (entity == null) {
            return map;
        }
        for (FieldMapping f : this.allFields()) {
            Object value = f.getter.get(entity);
            if (!allowedNull && value == null) continue;
            map.put(isProperty ? f.name : f.column, value);
        }
        return map;
    }

    @Override
    public Map<String, Object> toColumnMap(IEntity entity, boolean allowedNull) {
        return this.toMap(entity, false, allowedNull);
    }

    @Override
    public Map<String, Object> toEntityMap(IEntity entity, boolean allowedNull) {
        return this.toMap(entity, true, allowedNull);
    }

    @Override
    public <T> T valueByField(IEntity entity, String prop) {
        if (entity == null || prop == null) {
            return null;
        }
        FieldMapping f = this.fieldsMap.get(prop);
        return (T)(f == null ? null : f.getter.get(entity));
    }

    @Override
    public <T> T valueByColumn(IEntity entity, String column) {
        if (entity == null || column == null) {
            return null;
        }
        FieldMapping f = this.columnMap.get(column);
        return (T)(f == null ? null : f.getter.get(entity));
    }

    public <T extends IEntity> T copy(IEntity entity) {
        Object copy = this.newEntity();
        for (FieldMapping f : this.allFields()) {
            f.setter.set(copy, f.getter.get(entity));
        }
        return (T)copy;
    }

    @Override
    public IFragment table() {
        return this.tableSupplier == null ? this.tableSegment : m -> this.tableSupplier.get(this.tableName);
    }

    @Override
    public Optional<FieldMapping> findField(UniqueType type) {
        return Optional.ofNullable(this.uniqueFields.get((Object)type));
    }

    @Override
    public DbType db() {
        return this.dbType;
    }

    @Override
    public void db(DbType dbType) {
        this.dbType = dbType;
    }

    public IFragment dynamic(IWrapper wrapper) {
        IFragment table = wrapper.table(false);
        return table != null && table.notEmpty() ? table : this.table();
    }

    @Override
    public TableId tableId() {
        return this.tableId;
    }

    @Override
    public KeyMap<RefKey> refKeys() {
        return this.Ref_Keys;
    }

    protected <R> AMapping ref(String refName, RefKeyFunc<E> src, boolean isList, RefKeyFunc<R> ref, IGetter<E> finder) {
        this.Ref_Keys.put(refName, RefKey.refKey(refName, isList, src, ref, finder));
        return this;
    }

    protected AMapping ref(String refName, boolean isList, IGetter<E> finder) {
        this.Ref_Keys.put(refName, RefKey.refKey(refName, isList, null, null, finder));
        return this;
    }

    public String getSchema() {
        return this.schema;
    }

    @Override
    public Map<String, FieldMapping> getColumnMap() {
        return this.columnMap;
    }

    @Override
    public Map<String, FieldMapping> getFieldsMap() {
        return this.fieldsMap;
    }

    public List<String> getAllFields() {
        return this.allFields;
    }

    @Override
    public List<String> getAllColumns() {
        return this.allColumns;
    }

    @Override
    public CachedFrag getSelectAll() {
        return this.selectAll;
    }

    public Map<UniqueType, FieldMapping> getUniqueFields() {
        return this.uniqueFields;
    }

    public CachedFrag getTableSegment() {
        return this.tableSegment;
    }

    public TableId getTableId() {
        return this.tableId;
    }

    public KeyMap<RefKey> getRef_Keys() {
        return this.Ref_Keys;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    public void setTableSupplier(TableDynamic tableSupplier) {
        this.tableSupplier = tableSupplier;
    }
}

