/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.base.crud;

import cn.org.atool.fluent.mybatis.base.IEntity;
import cn.org.atool.fluent.mybatis.base.crud.IBaseQuery;
import cn.org.atool.fluent.mybatis.base.crud.IQuery;
import cn.org.atool.fluent.mybatis.base.crud.IWrapper;
import cn.org.atool.fluent.mybatis.base.crud.JoinBuilder;
import cn.org.atool.fluent.mybatis.base.crud.JoinToBuilder;
import cn.org.atool.fluent.mybatis.base.model.FieldMapping;
import cn.org.atool.fluent.mybatis.base.model.UniqueType;
import cn.org.atool.fluent.mybatis.exception.FluentMybatisException;
import cn.org.atool.fluent.mybatis.functions.IGetter;
import cn.org.atool.fluent.mybatis.functions.StringSupplier;
import cn.org.atool.fluent.mybatis.metadata.JoinType;
import cn.org.atool.fluent.mybatis.segment.BaseWrapper;
import cn.org.atool.fluent.mybatis.segment.JoinOn;
import cn.org.atool.fluent.mybatis.segment.fragment.Column;
import cn.org.atool.fluent.mybatis.segment.fragment.Fragments;
import cn.org.atool.fluent.mybatis.segment.fragment.IFragment;
import cn.org.atool.fluent.mybatis.segment.model.PagedOffset;
import cn.org.atool.fluent.mybatis.utility.LambdaUtil;
import java.util.HashSet;
import java.util.Set;

public abstract class BaseQuery<E extends IEntity, Q extends BaseQuery<E, Q>>
extends BaseWrapper<E, Q, Q>
implements IBaseQuery<E, Q> {
    private final Set<String> withRelations = new HashSet<String>();

    protected BaseQuery(StringSupplier table, StringSupplier alias, Class entityClass) {
        super(Fragments.fragment(table), alias, entityClass);
    }

    protected BaseQuery(IFragment table, StringSupplier alias, Class entityClass) {
        super(table, alias, entityClass);
    }

    @Override
    public Q distinct() {
        this.data.setDistinct(true);
        return (Q)this;
    }

    @Override
    public Q selectAll() {
        this.allFields().stream().map(c -> FieldMapping.alias(this.getTableAlias(), c)).forEach(xva$0 -> this.select((String)xva$0));
        return (Q)this;
    }

    @Override
    public Q selectId() {
        String primary = this.fieldName(UniqueType.PRIMARY_ID);
        if (primary == null) {
            throw new FluentMybatisException("The primary key of in table was not found.");
        }
        return this.select(primary);
    }

    public Q select(String ... columns) {
        if (columns == null) {
            return (Q)this;
        }
        for (String column : columns) {
            this.data.select(Column.set((IWrapper)this, column));
        }
        return (Q)this;
    }

    @Override
    public Q limit(int limit) {
        return (Q)this.limit(0, limit);
    }

    @Override
    public Q limit(int from, int limit) {
        this.data.setPaged(new PagedOffset(from, limit));
        return (Q)this;
    }

    @Override
    public Q last(String lastSql) {
        this.data.last(lastSql);
        return (Q)this;
    }

    @Override
    public IQuery union(IQuery ... queries) {
        return this.union("UNION", queries);
    }

    @Override
    public IQuery unionAll(IQuery ... queries) {
        return this.union("UNION ALL", queries);
    }

    public <QR extends BaseQuery<?, QR>> JoinOn<Q, QR, JoinToBuilder<Q>> join(QR query) {
        return JoinBuilder.from(this).join(query);
    }

    public <QR extends BaseQuery<?, QR>> JoinOn<Q, QR, JoinToBuilder<Q>> join(JoinType joinType, QR query) {
        switch (joinType) {
            case LeftJoin: {
                return JoinBuilder.from(this).leftJoin(query);
            }
            case RightJoin: {
                return JoinBuilder.from(this).rightJoin(query);
            }
        }
        return JoinBuilder.from(this).join(query);
    }

    public <ET> Q with(IGetter<ET> refMethod) {
        return this.with(LambdaUtil.resolve(refMethod));
    }

    public Q with(String refMethod) {
        this.mapping().ifPresent(m -> {
            if (m.refKeys().containsKey(refMethod)) {
                this.withRelations.add(refMethod);
            }
        });
        return (Q)this;
    }

    public Set<String> getWithRelations() {
        return this.withRelations;
    }
}

