/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.base;

import cn.org.atool.fluent.mybatis.annotation.NotField;
import cn.org.atool.fluent.mybatis.base.BaseEntity;
import cn.org.atool.fluent.mybatis.base.entity.IRichEntity;
import cn.org.atool.fluent.mybatis.utility.RefKit;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public abstract class RichEntity
extends BaseEntity
implements IRichEntity {
    @NotField
    protected transient Map<String, Optional<Object>> cached = new ConcurrentHashMap<String, Optional<Object>>(4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T invoke(boolean cached, String methodName, Object[] args) {
        if (cached) {
            if (this.cached.containsKey(methodName)) {
                return this.cached.get(methodName).orElse(null);
            }
            RichEntity richEntity = this;
            synchronized (richEntity) {
                if (this.cached.containsKey(methodName)) {
                    return this.cached.get(methodName).orElse(null);
                }
                Object result = RefKit.invoke(this.entityClass(), methodName, this.reArgs(args));
                if (result != null || !this.cached.containsKey(methodName)) {
                    this.cached.put(methodName, Optional.ofNullable(result));
                }
                return this.cached.get(methodName).orElse(null);
            }
        }
        return RefKit.invoke(this.entityClass(), methodName, this.reArgs(args));
    }

    void cached(String methodName, Object cached) {
        this.cached.put(methodName, Optional.ofNullable(cached));
    }

    @Override
    public <T> T invoke(String method, boolean cached) {
        return this.invoke(cached, method, new Object[0]);
    }

    private Object[] reArgs(Object[] args) {
        if (args == null || args.length == 0) {
            return new Object[]{this};
        }
        Object[] reArgs = new Object[args.length + 1];
        reArgs[0] = this;
        System.arraycopy(args, 0, reArgs, 1, args.length);
        return reArgs;
    }
}

