/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.base;

import cn.org.atool.fluent.mybatis.base.model.FieldMapping;
import cn.org.atool.fluent.mybatis.functions.TableSupplier;
import cn.org.atool.fluent.mybatis.utility.MybatisUtil;
import cn.org.atool.fluent.mybatis.utility.RefKit;
import java.io.Serializable;
import java.util.Map;

public interface IEntity
extends Serializable {
    default public Object findPk() {
        FieldMapping f = RefKit.byEntity(this.entityClass()).primaryMapping();
        return f == null ? null : f.getter.get(this);
    }

    default public Class<? extends IEntity> entityClass() {
        return MybatisUtil.entityClass(this.getClass());
    }

    default public Map<String, Object> toEntityMap() {
        return this.toEntityMap(false);
    }

    default public Map<String, Object> toEntityMap(boolean allowedNull) {
        return RefKit.entityKit(this.entityClass()).toEntityMap(this, allowedNull);
    }

    default public Map<String, Object> toColumnMap() {
        return this.toColumnMap(false);
    }

    default public Map<String, Object> toColumnMap(boolean allowNull) {
        return RefKit.entityKit(this.entityClass()).toColumnMap(this, allowNull);
    }

    default public <E extends IEntity> E copy() {
        return RefKit.entityKit(this.entityClass()).copy(this);
    }

    default public <E extends IEntity> E tableSupplier(TableSupplier supplier) {
        return (E)this;
    }

    default public <E extends IEntity> E tableSupplier(String supplier) {
        return (E)this;
    }

    default public String tableSupplier() {
        return null;
    }

    default public <T> T valueByField(String field) {
        return RefKit.entityKit(this.entityClass()).valueByField(this, field);
    }

    default public <T> T valueByColumn(String column) {
        return RefKit.entityKit(this.entityClass()).valueByColumn(this, column);
    }

    default public <T> T valueBy(FieldMapping fieldMapping) {
        return (T)fieldMapping.getter.get(this);
    }
}

