/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.base;

import cn.org.atool.fluent.mybatis.If;
import cn.org.atool.fluent.mybatis.base.IEntity;
import cn.org.atool.fluent.mybatis.base.RichEntity;
import cn.org.atool.fluent.mybatis.base.model.KeyMap;
import cn.org.atool.fluent.mybatis.functions.RefKey;
import cn.org.atool.fluent.mybatis.utility.MybatisUtil;
import cn.org.atool.fluent.mybatis.utility.RefKit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class EntityRefKit {
    public static <E, R> Set<R> values(List<E> entities, Function<E, R> getter) {
        return entities.stream().map(getter).collect(Collectors.toSet());
    }

    public static <E extends IEntity, R extends IEntity> void groupRelation(RefKey<E, R> refKey, List<E> srcEntities, List<R> refEntities) {
        Map<String, List<R>> map = EntityRefKit.toEntityMap(refEntities, refKey.ref);
        for (IEntity entity : srcEntities) {
            String key = (String)refKey.src.apply(entity);
            EntityRefKit.cache(entity, refKey.refMethodName, map.get(key), refKey.isList);
        }
    }

    public static void cache(IEntity entity, String keyName, List list, boolean isList) {
        if (entity != null) {
            if (!(entity instanceof RichEntity)) {
                throw new IllegalStateException("In order to use @RefMethod methods, Entity[" + entity.entityClass().getName() + "] must extends RichEntity.");
            }
            if (isList) {
                ((RichEntity)entity).cached(keyName, list == null ? Collections.emptyList() : list);
            } else {
                ((RichEntity)entity).cached(keyName, If.isEmpty(list) ? null : list.get(0));
            }
        }
    }

    public static <E> Map<String, List<E>> toEntityMap(List<E> entities, Function<E, String> keyFunc) {
        HashMap<String, List<E>> map = new HashMap<String, List<E>>();
        for (E e : entities) {
            String key = keyFunc.apply(e);
            if (!map.containsKey(key)) {
                map.put(key, new ArrayList());
            }
            ((List)map.get(key)).add(e);
        }
        return map;
    }

    public static Object findRefData(Class<IEntity> entityClass, IEntity entity, String method) {
        RefKey refKey = EntityRefKit.getRefKeyOfRefMethod(entityClass, method);
        return refKey == null ? null : refKey.finder.get(entity);
    }

    public static RefKey getRefKeyOfRefMethod(Class eClass, String methodName) {
        KeyMap<RefKey> keys = RefKit.byEntity(eClass).refKeys();
        if (keys.containsKey(methodName)) {
            return keys.get(methodName);
        }
        if (!methodName.startsWith("find")) {
            String method = "find" + MybatisUtil.capitalFirst(methodName);
            return keys.get(method);
        }
        return null;
    }
}

