/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.physics;

import com.almasb.fxgl.core.math.Vec2;
import com.almasb.fxgl.entity.components.TransformComponent;
import com.almasb.fxgl.physics.HitBox;

public final class SAT {
    private static final MinMax box2axis1 = new MinMax();
    private static final MinMax box2axis2 = new MinMax();
    private static final MinMax box1axis3 = new MinMax();
    private static final MinMax box1axis4 = new MinMax();

    private SAT() {
    }

    public static boolean isColliding(HitBox box1, HitBox box2, double angle1, double angle2, TransformComponent t1, TransformComponent t2) {
        Vec2 axis1 = box1.axes[0];
        Vec2 axis2 = box1.axes[1];
        Vec2 axis3 = box2.axes[0];
        Vec2 axis4 = box2.axes[1];
        SAT.computeMinMax(box2.corners, axis1, box2axis1);
        if (box1.axis1MinMax.isSeparated(box2axis1)) {
            return false;
        }
        SAT.computeMinMax(box2.corners, axis2, box2axis2);
        if (box1.axis2MinMax.isSeparated(box2axis2)) {
            return false;
        }
        SAT.computeMinMax(box1.corners, axis3, box1axis3);
        if (box2.axis1MinMax.isSeparated(box1axis3)) {
            return false;
        }
        SAT.computeMinMax(box1.corners, axis4, box1axis4);
        return !box2.axis2MinMax.isSeparated(box1axis4);
    }

    static void computeMinMax(Vec2[] corners, Vec2 axis, MinMax minMax) {
        float value;
        float min = value = Vec2.dot((Vec2)corners[0], (Vec2)axis);
        float max = value;
        for (int i = 1; i < 4; ++i) {
            value = Vec2.dot((Vec2)corners[i], (Vec2)axis);
            min = Math.min(min, value);
            max = Math.max(max, value);
        }
        minMax.min = min;
        minMax.max = max;
    }

    public static class MinMax {
        private float min = 0.0f;
        private float max = 0.0f;

        private boolean isSeparated(MinMax other) {
            return this.max < other.min || other.max < this.min;
        }
    }
}

