/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.particle;

import com.almasb.fxgl.core.collection.Array;
import com.almasb.fxgl.core.collection.UnorderedArray;
import com.almasb.fxgl.core.math.FXGLMath;
import com.almasb.fxgl.core.pool.Pools;
import com.almasb.fxgl.particle.Particle;
import com.almasb.fxgl.texture.Texture;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javafx.animation.Interpolator;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.Point2D;
import javafx.scene.effect.BlendMode;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Duration;

public final class ParticleEmitter {
    private IntegerProperty numParticles = new SimpleIntegerProperty(25);
    private DoubleProperty emissionRate = new SimpleDoubleProperty(1.0);
    private int maxEmissions = Integer.MAX_VALUE;
    private DoubleProperty minSize = new SimpleDoubleProperty(9.0);
    private DoubleProperty maxSize = new SimpleDoubleProperty(12.0);
    private ObjectProperty<Paint> startColor = new SimpleObjectProperty((Object)Color.TRANSPARENT);
    private ObjectProperty<Paint> endColor = new SimpleObjectProperty((Object)Color.TRANSPARENT);
    private ObjectProperty<BlendMode> blendMode = new SimpleObjectProperty((Object)BlendMode.SRC_OVER);
    private ObjectProperty<Interpolator> interpolator = new SimpleObjectProperty((Object)Interpolator.LINEAR);
    private BooleanProperty allowParticleRotation = new SimpleBooleanProperty(false);
    private Consumer<Particle> control = null;
    private Function<Double, Point2D> parametricEquation = null;
    private Supplier<Point2D> accelerationFunction = () -> Point2D.ZERO;
    private Function<Integer, Point2D> velocityFunction = i -> Point2D.ZERO;
    private Function<Integer, Point2D> spawnPointFunction = i -> Point2D.ZERO;
    private Function<Integer, Point2D> scaleOriginFunction = i -> Point2D.ZERO;
    private Function<Integer, Point2D> scaleFunction = i -> Point2D.ZERO;
    private Supplier<Point2D> entityScaleFunction = () -> new Point2D(1.0, 1.0);
    private Function<Integer, Duration> expireFunction = i -> Duration.seconds((double)1.0);
    private Image sourceImage = null;
    private boolean isPaused = false;
    private double rateAC = 1.0;
    private int emissions = 0;
    private Array<Particle> emissionParticles = new UnorderedArray(this.getNumParticles());

    public IntegerProperty numParticlesProperty() {
        return this.numParticles;
    }

    public int getNumParticles() {
        return this.numParticles.get();
    }

    public void setNumParticles(int numParticles) {
        this.numParticles.set(numParticles);
    }

    public DoubleProperty emissionRateProperty() {
        return this.emissionRate;
    }

    public double getEmissionRate() {
        return this.emissionRate.get();
    }

    public void setEmissionRate(double emissionRate) {
        this.emissionRate.set(emissionRate);
    }

    public int getMaxEmissions() {
        return this.maxEmissions;
    }

    public void setMaxEmissions(int maxEmissions) {
        this.maxEmissions = maxEmissions;
    }

    public boolean isFinished() {
        return this.emissions == this.maxEmissions;
    }

    public double getMinSize() {
        return this.minSize.get();
    }

    public DoubleProperty minSizeProperty() {
        return this.minSize;
    }

    public void setMinSize(double minSize) {
        this.minSize.set(minSize);
    }

    public double getMaxSize() {
        return this.maxSize.get();
    }

    public DoubleProperty maxSizeProperty() {
        return this.maxSize;
    }

    public void setMaxSize(double maxSize) {
        this.maxSize.set(maxSize);
    }

    public void setSize(double min, double max) {
        this.setMinSize(min);
        this.setMaxSize(max);
    }

    private double getRandomSize() {
        return FXGLMath.random((double)this.getMinSize(), (double)this.getMaxSize());
    }

    public Paint getStartColor() {
        return (Paint)this.startColor.get();
    }

    public ObjectProperty<Paint> startColorProperty() {
        return this.startColor;
    }

    public void setStartColor(Paint startColor) {
        this.startColor.set((Object)startColor);
    }

    public Paint getEndColor() {
        return (Paint)this.endColor.get();
    }

    public ObjectProperty<Paint> endColorProperty() {
        return this.endColor;
    }

    public void setEndColor(Paint endColor) {
        this.endColor.set((Object)endColor);
    }

    public void setColor(Paint color) {
        this.setStartColor(color);
        this.setEndColor(color);
    }

    public BlendMode getBlendMode() {
        return (BlendMode)this.blendMode.get();
    }

    public ObjectProperty<BlendMode> blendModeProperty() {
        return this.blendMode;
    }

    public void setBlendMode(BlendMode blendMode) {
        this.blendMode.set((Object)blendMode);
    }

    public Interpolator getInterpolator() {
        return (Interpolator)this.interpolator.get();
    }

    public ObjectProperty<Interpolator> interpolatorProperty() {
        return this.interpolator;
    }

    public void setInterpolator(Interpolator interpolator) {
        this.interpolator.set((Object)interpolator);
    }

    public boolean isAllowParticleRotation() {
        return this.allowParticleRotation.get();
    }

    public BooleanProperty allowParticleRotationProperty() {
        return this.allowParticleRotation;
    }

    public void setAllowParticleRotation(boolean allowParticleRotation) {
        this.allowParticleRotation.set(allowParticleRotation);
    }

    public Consumer<Particle> getControl() {
        return this.control;
    }

    public void setControl(Consumer<Particle> control) {
        this.control = control;
    }

    public Function<Double, Point2D> getParametricEquation() {
        return this.parametricEquation;
    }

    public void setParametricEquation(Function<Double, Point2D> parametricEquation) {
        this.parametricEquation = parametricEquation;
    }

    public Supplier<Point2D> getAccelerationFunction() {
        return this.accelerationFunction;
    }

    public void setAccelerationFunction(Supplier<Point2D> gravityFunction) {
        this.accelerationFunction = gravityFunction;
    }

    public void setVelocityFunction(Function<Integer, Point2D> velocityFunction) {
        this.velocityFunction = velocityFunction;
    }

    public void setSpawnPointFunction(Function<Integer, Point2D> spawnPointFunction) {
        this.spawnPointFunction = spawnPointFunction;
    }

    public void setScaleOriginFunction(Function<Integer, Point2D> scaleOriginFunction) {
        this.scaleOriginFunction = scaleOriginFunction;
    }

    public void setScaleFunction(Function<Integer, Point2D> scaleFunction) {
        this.scaleFunction = scaleFunction;
    }

    public void setEntityScaleFunction(Supplier<Point2D> entityScaleFunction) {
        this.entityScaleFunction = entityScaleFunction;
    }

    public void setExpireFunction(Function<Integer, Duration> expireFunction) {
        this.expireFunction = expireFunction;
    }

    public void setSourceImage(Image sourceImage) {
        this.sourceImage = sourceImage;
    }

    public void setSourceImage(Texture texture) {
        this.setSourceImage(texture.getImage());
    }

    boolean isPaused() {
        return this.isPaused;
    }

    void pause() {
        this.isPaused = true;
    }

    void resume() {
        this.isPaused = false;
    }

    Array<Particle> emit(double x, double y) {
        double rate = this.getEmissionRate();
        this.rateAC += rate;
        if (this.rateAC < 1.0 || rate == 0.0 || this.isPaused || this.isFinished()) {
            return Array.empty();
        }
        this.rateAC = 0.0;
        ++this.emissions;
        this.emissionParticles.clear();
        int num = this.getNumParticles();
        for (int i = 0; i < num; ++i) {
            this.emissionParticles.add((Object)this.emit(i, x, y));
        }
        return this.emissionParticles;
    }

    private Particle emit(int i, double x, double y) {
        Particle particle = (Particle)Pools.obtain(Particle.class);
        particle.init(this.getControl(), this.sourceImage, this.spawnPointFunction.apply(i).add(x, y), this.velocityFunction.apply(i), this.accelerationFunction.get(), this.getRandomSize(), this.scaleOriginFunction.apply(i), this.scaleFunction.apply(i), this.entityScaleFunction.get(), this.expireFunction.apply(i), this.getStartColor(), this.getEndColor(), this.getBlendMode(), this.getInterpolator(), this.isAllowParticleRotation(), this.getParametricEquation());
        return particle;
    }
}

