/*
 * Decompiled with CFR 0.152.
 */
package com.gexin.rp.sdk.base.uitls;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

public class Base64Util {
    private static Class<?> cls1;
    private static Constructor<?> cons1;
    private static Object obj1;
    private static Method encodeMethod;
    private static Class<?> cls2;
    private static Constructor<?> cons2;
    private static Object obj2;
    private static Method decodeMethod;

    public static String getBASE64(byte[] bytes) {
        String result = "";
        if (bytes == null) {
            return null;
        }
        Object res = null;
        try {
            res = encodeMethod.invoke(obj1, new Object[]{bytes});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        result = String.valueOf(res);
        return result;
    }

    public static String getBASE64FromFile(String fileName) throws IOException {
        if (fileName == null) {
            return null;
        }
        FileInputStream input = null;
        try {
            input = new FileInputStream(fileName);
            byte[] bytes = new byte[((InputStream)input).available()];
            ((InputStream)input).read(bytes);
            String string = Base64Util.getBASE64(bytes);
            return string;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (input != null) {
                ((InputStream)input).close();
            }
        }
    }

    public static byte[] getBytesFromBASE64(String s) {
        byte[] result = new byte[]{};
        if (s == null) {
            return null;
        }
        Object res = null;
        try {
            res = decodeMethod.invoke(obj2, s);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        result = (byte[])res;
        return result;
    }

    public static void main(String[] args) {
        String content = "just for test!";
        String base64Str = Base64Util.getBASE64(content.getBytes());
        System.out.println("encode to base64 :\n" + base64Str);
        System.out.println();
        String retStr = new String(Base64Util.getBytesFromBASE64(base64Str));
        System.out.println("decode from base64:\n" + retStr);
    }

    static {
        String javaVersion = System.getProperty("java.version");
        double doubleJavaVersion = Double.parseDouble(javaVersion.substring(0, 3));
        if (doubleJavaVersion >= 1.9) {
            try {
                cls1 = Class.forName("java.util.Base64$Encoder");
                cons1 = cls1.getDeclaredConstructor(Boolean.TYPE, byte[].class, Integer.TYPE, Boolean.TYPE);
                cons1.setAccessible(true);
                obj1 = cons1.newInstance(false, null, -1, true);
                encodeMethod = cls1.getMethod("encodeToString", byte[].class);
                cls2 = Class.forName("java.util.Base64$Decoder");
                cons2 = cls2.getDeclaredConstructor(Boolean.TYPE, Boolean.TYPE);
                cons2.setAccessible(true);
                obj2 = cons2.newInstance(false, false);
                decodeMethod = cls2.getMethod("decode", String.class);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            try {
                cls1 = Class.forName("sun.misc.BASE64Encoder");
                cons1 = cls1.getConstructor(new Class[0]);
                obj1 = cons1.newInstance(new Object[0]);
                encodeMethod = cls1.getMethod("encode", byte[].class);
                cls2 = Class.forName("sun.misc.BASE64Decoder");
                cons2 = cls2.getConstructor(new Class[0]);
                obj2 = cons2.newInstance(new Object[0]);
                decodeMethod = cls2.getMethod("decodeBuffer", String.class);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

