/*
 * Decompiled with CFR 0.152.
 */
package com.gexin.fastjson.serializer;

import com.gexin.fastjson.parser.DefaultJSONParser;
import com.gexin.fastjson.parser.JSONLexer;
import com.gexin.fastjson.parser.deserializer.ObjectDeserializer;
import com.gexin.fastjson.serializer.JSONSerializer;
import com.gexin.fastjson.serializer.ObjectSerializer;
import com.gexin.fastjson.serializer.SerializeWriter;
import com.gexin.fastjson.serializer.SerializerFeature;
import com.gexin.fastjson.util.TypeUtils;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.concurrent.atomic.AtomicLong;

public class LongCodec
implements ObjectSerializer,
ObjectDeserializer {
    public static LongCodec instance = new LongCodec();

    @Override
    public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType, int features) throws IOException {
        SerializeWriter out = serializer.out;
        if (object == null) {
            out.writeNull(SerializerFeature.WriteNullNumberAsZero);
        } else {
            long value = (Long)object;
            out.writeLong(value);
            if (out.isEnabled(SerializerFeature.WriteClassName) && value <= Integer.MAX_VALUE && value >= Integer.MIN_VALUE && fieldType != Long.class) {
                out.write(76);
            }
        }
    }

    @Override
    public <T> T deserialze(DefaultJSONParser parser, Type clazz, Object fieldName) {
        Long longObject;
        JSONLexer lexer = parser.lexer;
        if (lexer.token() == 2) {
            long longValue = lexer.longValue();
            lexer.nextToken(16);
            longObject = longValue;
        } else {
            Object value = parser.parse();
            if (value == null) {
                return null;
            }
            longObject = TypeUtils.castToLong(value);
        }
        return (T)(clazz == AtomicLong.class ? new AtomicLong(longObject) : longObject);
    }

    @Override
    public int getFastMatchToken() {
        return 2;
    }
}

