/*
 * Decompiled with CFR 0.152.
 */
package com.gexin.rp.sdk.http;

import com.gexin.fastjson.JSONObject;
import com.gexin.rp.sdk.base.IAliasResult;
import com.gexin.rp.sdk.base.IBatch;
import com.gexin.rp.sdk.base.IGtAPN;
import com.gexin.rp.sdk.base.IGtAlias;
import com.gexin.rp.sdk.base.IIGtGroup;
import com.gexin.rp.sdk.base.IIGtPush;
import com.gexin.rp.sdk.base.IIGtQuery;
import com.gexin.rp.sdk.base.IListProvider;
import com.gexin.rp.sdk.base.IPushEventListener;
import com.gexin.rp.sdk.base.IPushResult;
import com.gexin.rp.sdk.base.IQueryResult;
import com.gexin.rp.sdk.base.impl.AppMessage;
import com.gexin.rp.sdk.base.impl.GroupMessage;
import com.gexin.rp.sdk.base.impl.ListMessage;
import com.gexin.rp.sdk.base.impl.Message;
import com.gexin.rp.sdk.base.impl.PushResult;
import com.gexin.rp.sdk.base.impl.QueryResult;
import com.gexin.rp.sdk.base.impl.SingleMessage;
import com.gexin.rp.sdk.base.impl.TagMessage;
import com.gexin.rp.sdk.base.impl.TagsTarget;
import com.gexin.rp.sdk.base.impl.Target;
import com.gexin.rp.sdk.base.uitls.AppConditions;
import com.gexin.rp.sdk.base.uitls.Base64Util;
import com.gexin.rp.sdk.base.uitls.LangUtil;
import com.gexin.rp.sdk.base.uitls.SignUtil;
import com.gexin.rp.sdk.base.uitls.StringUtils;
import com.gexin.rp.sdk.exceptions.PushAppException;
import com.gexin.rp.sdk.exceptions.RequestException;
import com.gexin.rp.sdk.http.BatchImpl;
import com.gexin.rp.sdk.http.GtHttpProxy;
import com.gexin.rp.sdk.http.HttpManager;
import com.gexin.rp.sdk.http.IGtHttpProxy;
import com.gexin.rp.sdk.http.utils.AliasResultUtil;
import com.gexin.rp.sdk.http.utils.DomainConfig;
import com.gexin.rp.sdk.http.utils.GTConfig;
import com.gexin.rp.sdk.http.utils.GtHttpException;
import com.gexin.rp.sdk.http.utils.OSDomainWrapper;
import com.gexin.rp.sdk.http.utils.ParamUtils;
import com.gexin.rp.sdk.http.utils.PushDomainManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.LinkedBlockingQueue;

public class GtPush
implements IIGtPush,
IIGtQuery,
IGtAPN,
IGtAlias,
IIGtGroup {
    private String appKey;
    private String authToken;
    private String masterSecret;
    private String domainKey;
    private static HttpManager httpManager = new HttpManager();
    private String serialNumber;
    private Queue<String> infos = new LinkedBlockingQueue<String>();

    public GtPush(String domainUrl, String appKey, String masterSecret, Boolean useSSL, String domainKey) {
        this.appKey = appKey;
        this.masterSecret = masterSecret;
        this.domainKey = domainKey;
        this.serialNumber = appKey + "_" + System.currentTimeMillis();
        List<String> domainUrls = null;
        if (StringUtils.isNotBlank((CharSequence)domainUrl)) {
            domainUrls = Arrays.asList(domainUrl.split(","));
        }
        if (useSSL == null && domainUrls != null && domainUrls.get(0).toLowerCase().startsWith("https")) {
            useSSL = true;
        }
        useSSL = useSSL == null ? false : useSSL;
        GtHttpProxy proxy = new GtHttpProxy(new IGtHttpProxy());
        httpManager.setProxy(proxy);
        PushDomainManager.initProxy(proxy);
        OSDomainWrapper wrapper = new OSDomainWrapper(appKey, useSSL, Boolean.getBoolean("needOSAsigned"), domainUrls);
        PushDomainManager.initOSDomain(domainKey, wrapper);
        this.startOptimize();
    }

    protected Map<String, Object> httpPostJSON(Map<String, Object> data) {
        return this.httpPostJSON(data, false);
    }

    protected Map<String, Object> httpPostJSON(String url, Map<String, Object> data) {
        return this.httpPostJSON(url, data, false);
    }

    protected Map<String, Object> httpPostJSON(Map<String, Object> data, boolean gzip) {
        return this.httpPostJSON(PushDomainManager.getDomainUrl(this.domainKey), data, gzip);
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public String getDomainKey() {
        return this.domainKey;
    }

    /*
     * Unable to fully structure code
     */
    protected Map<String, Object> httpPostJSON(String url, Map<String, Object> data, boolean gzip) {
        data.put("version", GTConfig.getSDKVersion());
        data.put("authToken", this.authToken);
        if (!PushDomainManager.domainMap.get(this.domainKey).isAssigned()) {
            data.put("domainHash", PushDomainManager.domainMap.get(this.domainKey).getDomainHash());
        }
        response = null;
        try {
            response = this.httpPost(url, data, gzip);
        }
        catch (Exception e) {
            PushDomainManager.notifyServerError(this.domainKey, url);
            throw new RuntimeException("\u8fde\u63a5\u5f02\u5e38", e);
        }
        if (response != null) {
            if ("sign_error".equals(response.get("result"))) {
                try {
                    if (!this.connect()) ** GOTO lbl37
                    data.put("authToken", this.authToken);
                    response = this.httpPost(url, data, gzip);
                }
                catch (Exception e) {
                    PushDomainManager.notifyServerError(this.domainKey, url);
                    throw new RuntimeException("\u8fde\u63a5\u5f02\u5e38", e);
                }
            } else if ("domain_config_error".equals(response.get("result"))) {
                if (response.get("domainConfig") != null) {
                    domainConfig = (DomainConfig)JSONObject.parseObject((String)((String)response.get("domainConfig")), DomainConfig.class);
                    PushDomainManager.notifyDomainError(this.domainKey, domainConfig);
                }
                PushDomainManager.domainMap.get(this.domainKey).setDomainHash((String)response.get("domainHash"));
                try {
                    response = this.httpPost(PushDomainManager.domainMap.get(this.domainKey).getUsableDomainUrl(), data, gzip);
                }
                catch (Exception e) {
                    PushDomainManager.notifyServerError(this.domainKey, url);
                    throw new RuntimeException("\u8fde\u63a5\u5f02\u5e38", e);
                }
            }
        }
lbl37:
        // 7 sources

        PushDomainManager.reSetContinuousFailCount(this.domainKey, url);
        return response;
    }

    protected Map<String, Object> httpPost(String url, Map<String, Object> data, boolean gzip) throws GtHttpException {
        Map<String, Object> response = null;
        try {
            PushDomainManager.incrementUseCount(this.domainKey, url);
            response = httpManager.httpPostJSON(url, data, gzip);
        }
        catch (GtHttpException e) {
            PushDomainManager.incrementFailCount(this.domainKey, url);
            throw e;
        }
        catch (RequestException e) {
            PushDomainManager.incrementFailCount(this.domainKey, url);
            throw e;
        }
        return response;
    }

    @Deprecated
    public boolean connect() throws IOException {
        long timeStamp = System.currentTimeMillis();
        String sign = SignUtil.getSign((String)this.appKey, (String)this.masterSecret, (long)timeStamp);
        HashMap<String, Object> postData = new HashMap<String, Object>();
        postData.put("action", "connect");
        postData.put("appkey", this.appKey);
        postData.put("timeStamp", timeStamp);
        postData.put("sign", sign);
        postData.put("version", GTConfig.getSDKVersion());
        Map<String, Object> response = httpManager.httpPostJSON(PushDomainManager.getDomainUrl(this.domainKey), postData, false);
        String result = LangUtil.parseString((Object)response.get("result"));
        if (result != null && "success".equals(result)) {
            String authToken = LangUtil.parseString((Object)response.get("authtoken"));
            if (authToken != null) {
                this.authToken = authToken;
            }
            return true;
        }
        return false;
    }

    @Deprecated
    public void close() throws IOException {
        HashMap<String, Object> postData = new HashMap<String, Object>();
        postData.put("action", "close");
        postData.put("appkey", this.appKey);
        postData.put("version", GTConfig.getSDKVersion());
        postData.put("authToken", this.authToken);
        httpManager.httpPostJSON(PushDomainManager.getDomainUrl(this.domainKey), postData, false);
    }

    public IPushResult pushMessageToSingle(SingleMessage message, Target target) {
        return this.pushMessageToSingle(message, target, null);
    }

    public IPushResult pushMessageToSingleByTag(String appId, SingleMessage message, TagsTarget target) {
        return this.pushMessageToSingleByTag(appId, message, target, null);
    }

    public IPushResult pushMessageToSingleByTag(String appId, SingleMessage message, TagsTarget target, String requestId) {
        long start = System.currentTimeMillis();
        if (requestId == null || "".equals(requestId.trim())) {
            requestId = UUID.randomUUID().toString();
        }
        PushResult pushResult = new PushResult();
        ParamUtils.checkAppid((Message)message, appId);
        Map<String, Object> postData = this.getSingleMessagePostData(appId, message, target, requestId);
        String url = PushDomainManager.getDomainUrl(this.domainKey);
        Map<String, Object> response = this.httpPostJSON(url, postData);
        pushResult.setResponse(response);
        long end = System.currentTimeMillis();
        OSDomainWrapper wrapper = PushDomainManager.domainMap.get(this.domainKey);
        wrapper.incrementSingleCount(url);
        wrapper.addSingleTime(url, end - start);
        return pushResult;
    }

    public IPushResult pushMessageToSingle(SingleMessage message, Target target, String requestId) {
        return this.pushMessageToSingle(message, target, requestId, GTConfig.pushSingleNeedAliasDetail());
    }

    public IPushResult pushMessageToSingle(SingleMessage message, Target target, String requestId, boolean aliasDetails) {
        long start = System.currentTimeMillis();
        if (requestId == null || "".equals(requestId.trim())) {
            requestId = UUID.randomUUID().toString();
        }
        PushResult pushResult = new PushResult();
        ParamUtils.checkAppid((Message)message, target);
        Map<String, Object> postData = this.getSingleMessagePostData(message, target, requestId, aliasDetails);
        String url = PushDomainManager.getDomainUrl(this.domainKey);
        Map<String, Object> response = this.httpPostJSON(url, postData);
        pushResult.setResponse(response);
        long end = System.currentTimeMillis();
        OSDomainWrapper wrapper = PushDomainManager.domainMap.get(this.domainKey);
        wrapper.incrementSingleCount(url);
        wrapper.addSingleTime(url, end - start);
        return pushResult;
    }

    Map<String, Object> getSingleMessagePostData(String appId, SingleMessage message, TagsTarget tagsTarget, String requestId) {
        HashMap<String, Object> postData = new HashMap<String, Object>(16);
        postData.put("action", "pushMessageToSingleByTagAction");
        postData.put("appkey", this.appKey);
        if (requestId != null) {
            postData.put("requestId", requestId);
        }
        postData.put("clientData", Base64Util.getBASE64((byte[])message.getData().getTransparent().toByteArray()));
        postData.put("transmissionContent", message.getData().getTransmissionContent());
        postData.put("isOffline", message.isOffline());
        postData.put("offlineExpireTime", message.getOfflineExpireTime());
        postData.put("appId", appId);
        if (tagsTarget == null) {
            throw new RuntimeException("tagsTarget can not by null.");
        }
        if (tagsTarget.getTagSet() == null || tagsTarget.getTagSet().isEmpty()) {
            throw new RuntimeException("tagsTarget.tagSet can not be empty.");
        }
        int tagLimit = GTConfig.getPushToListByTagTagLimit();
        if (tagsTarget.getTagSet().size() > tagLimit) {
            throw new RuntimeException("tagSet can not be more than" + tagLimit);
        }
        postData.put("clientId", tagsTarget.getClientId());
        StringBuilder sb = new StringBuilder();
        for (String tag : tagsTarget.getTagSet()) {
            if (StringUtils.isBlank((CharSequence)tag)) {
                throw new RuntimeException("value in tagSet cannot be empty.");
            }
            sb.append(tag).append(',');
        }
        if (sb.length() == 0) {
            throw new RuntimeException("value in tagSet cannot be empty.");
        }
        String tags = sb.substring(0, sb.length() - 1);
        postData.put("tag", tags);
        postData.put("opType", tagsTarget.getOpType());
        postData.put("type", 2);
        postData.put("pushType", message.getData().getPushType());
        postData.put("pushNetWorkType", message.getPushNetWorkType());
        this.validateStrategyJson(postData, message.getStrategyJson());
        return postData;
    }

    private void validateStrategyJson(Map<String, Object> postData, String strategyJson) {
        if (StringUtils.isNotBlank((CharSequence)strategyJson)) {
            JSONObject.parseObject((String)strategyJson);
            postData.put("strategyJson", strategyJson);
        }
    }

    Map<String, Object> getSingleMessagePostData(SingleMessage message, Target target, String requestId) {
        HashMap<String, Object> postData = new HashMap<String, Object>();
        postData.put("action", "pushMessageToSingleAction");
        postData.put("appkey", this.appKey);
        if (requestId != null) {
            postData.put("requestId", requestId);
        }
        postData.put("clientData", Base64Util.getBASE64((byte[])message.getData().getTransparent().toByteArray()));
        postData.put("transmissionContent", message.getData().getTransmissionContent());
        postData.put("isOffline", message.isOffline());
        postData.put("offlineExpireTime", message.getOfflineExpireTime());
        postData.put("appId", target.getAppId());
        postData.put("clientId", target.getClientId());
        postData.put("alias", target.getAlias());
        postData.put("type", 2);
        postData.put("pushType", message.getData().getPushType());
        postData.put("pushNetWorkType", message.getPushNetWorkType());
        this.validateStrategyJson(postData, message.getStrategyJson());
        return postData;
    }

    Map<String, Object> getSingleMessagePostData(SingleMessage message, Target target, String requestId, boolean aliasDetails) {
        Map<String, Object> postData = this.getSingleMessagePostData(message, target, requestId);
        postData.put("aliasDetails", aliasDetails);
        return postData;
    }

    private void startOptimize() {
        if (Boolean.getBoolean("noNeedOptimization")) {
            return;
        }
        Thread infoThread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        Thread.sleep(GTConfig.getOptimizationInterval());
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    try {
                        GtPush.this.doOptimization();
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        }, "OptimizationThread");
        infoThread.setDaemon(true);
        infoThread.start();
    }

    private void doOptimization() {
        String info;
        if (!this.infos.isEmpty()) {
            Iterator it = this.infos.iterator();
            this.infos.iterator();
            StringBuilder stringBuilder = new StringBuilder();
            while (it.hasNext()) {
                stringBuilder.append((String)it.next()).append("|");
            }
            stringBuilder.delete(stringBuilder.length() - 2, stringBuilder.length() - 1);
            if (this.doOptimization(stringBuilder.toString())) {
                this.infos.clear();
            }
        }
        if (!this.doOptimization(info = this.getOptimizationInfo())) {
            if (this.infos.size() > 4) {
                this.infos.remove();
            }
            this.infos.add(info);
        }
        PushDomainManager.domainMap.get(this.domainKey).reSetdomainState();
        PushDomainManager.domainMap.get(this.domainKey).getIntervalFusingCount().set(0);
    }

    private String getOptimizationInfo() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{\"MainUrl\":\"").append(PushDomainManager.getMainUrl(this.domainKey)).append("\"");
        stringBuilder.append(",\"needOSAsigned\":").append(Boolean.getBoolean("needOSAsigned"));
        stringBuilder.append(",\"domainUrls\":").append(JSONObject.toJSONString(PushDomainManager.domainMap.get(this.domainKey).getDomainUrls()));
        stringBuilder.append(",\"version\":\"").append(GTConfig.getSDKVersion()).append("\"");
        stringBuilder.append(",\"serialNumber\":\"").append(this.serialNumber).append("\"");
        stringBuilder.append(",\"allFusingCount\":").append(PushDomainManager.domainMap.get(this.domainKey).getAllFusingCount().get());
        stringBuilder.append(",\"intervalFusingCount\":").append(PushDomainManager.domainMap.get(this.domainKey).getIntervalFusingCount().get());
        stringBuilder.append(",\"domainStates\":").append(PushDomainManager.domainMap.get(this.domainKey).getAllDomainState()).append("}");
        return stringBuilder.toString();
    }

    private boolean doOptimization(String info) {
        HashMap<String, Object> postData = new HashMap<String, Object>(2);
        postData.put("action", "getDomainConfigAction");
        postData.put("appkey", this.appKey);
        postData.put("info", info);
        try {
            Map<String, Object> response = this.httpPostJSON(postData, true);
            String result = (String)response.get("result");
            if ("ok".equals(result)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public void pushMessageToList(ListMessage message, IListProvider listProvider, IPushEventListener listener) {
        List targetList;
        String contentId = this.getContentId(message);
        int page = 0;
        while ((targetList = listProvider.getClientList(page)) != null) {
            IPushResult pushResult = this.pushMessageToList(contentId, targetList);
            listener.process(pushResult);
            ++page;
        }
    }

    public String getContentId(ListMessage message) {
        return this.getListAppContentId((Message)message, null);
    }

    public String getContentId(ListMessage message, String taskGroupName) {
        return this.getListAppContentId((Message)message, taskGroupName);
    }

    public boolean cancelContentId(String contentId) {
        HashMap<String, Object> postData = new HashMap<String, Object>();
        boolean success = false;
        postData.put("action", "cancleContentIdAction");
        postData.put("appkey", this.appKey);
        postData.put("contentId", contentId);
        Map<String, Object> response = this.httpPostJSON(postData);
        if ("ok".equals(LangUtil.parseString((Object)response.get("result")))) {
            success = true;
        }
        return success;
    }

    private IPushResult blackCidList(String appId, List<String> cidList, int optType) {
        HashMap<String, Object> postData = new HashMap<String, Object>();
        PushResult pushResult = new PushResult();
        int limit = GTConfig.getMaxLenOfBlackCidList();
        if (limit < cidList.size()) {
            HashMap<String, String> response = new HashMap<String, String>();
            response.put("result", "cid size:" + cidList.size() + " beyond the limit:" + limit);
            pushResult.setResponse(response);
            return pushResult;
        }
        postData.put("action", "blackCidAction");
        postData.put("appkey", this.appKey);
        postData.put("appId", appId);
        postData.put("cidList", cidList);
        postData.put("optType", optType);
        Map<String, Object> response = this.httpPostJSON(postData, true);
        pushResult.setResponse(response);
        return pushResult;
    }

    public IPushResult addCidListToBlk(String appId, List<String> cidList) {
        return this.blackCidList(appId, cidList, 1);
    }

    public IPushResult restoreCidListFromBlk(String appId, List<String> cidList) {
        return this.blackCidList(appId, cidList, 2);
    }

    public IPushResult pushMessageToListByTag(String appId, String contentId, List<TagsTarget> targets) {
        HashMap<String, Object> postData = new HashMap<String, Object>(16);
        PushResult pushResult = new PushResult();
        postData.put("action", "pushMessageToListByTagAction");
        postData.put("appId", appId);
        postData.put("appkey", this.appKey);
        postData.put("contentId", contentId);
        int limit = GTConfig.getAsyncListLimit();
        if (targets == null || targets.isEmpty()) {
            throw new RuntimeException("targets can not be empty.");
        }
        if (targets.size() > limit) {
            HashMap<String, String> response = new HashMap<String, String>(2);
            response.put("result", "target size:" + targets.size() + " beyond the limit:" + limit);
            pushResult.setResponse(response);
            return pushResult;
        }
        this.checkTagsTargetCidAndTag(targets);
        ArrayList<Map> list = new ArrayList<Map>(targets.size());
        for (TagsTarget target : targets) {
            Map map = target.toMap();
            if (map == null) continue;
            list.add(map);
        }
        postData.put("clientIdList", list);
        postData.put("type", 2);
        long start = System.currentTimeMillis();
        String url = PushDomainManager.getDomainUrl(this.domainKey);
        Map<String, Object> response = this.httpPostJSON(url, postData, true);
        long end = System.currentTimeMillis();
        OSDomainWrapper wrapper = PushDomainManager.domainMap.get(this.domainKey);
        wrapper.incrementListCount(url);
        wrapper.addListTime(url, end - start);
        pushResult.setResponse(response);
        return pushResult;
    }

    private void checkTagsTargetCidAndTag(List<TagsTarget> list) {
        int tagLimit = GTConfig.getPushToListByTagTagLimit();
        Iterator<TagsTarget> iterator = list.iterator();
        while (iterator.hasNext()) {
            TagsTarget tagsTarget = iterator.next();
            if (tagsTarget == null || tagsTarget.getClientId() == null) {
                iterator.remove();
                continue;
            }
            if (tagsTarget.getTagSet() == null || tagsTarget.getTagSet().isEmpty()) {
                throw new RuntimeException("tagSet can not be empty.");
            }
            if (tagsTarget.getTagSet().size() <= tagLimit) continue;
            throw new RuntimeException("tagSet can not be more than " + tagLimit);
        }
    }

    public IPushResult pushMessageToList(String contentId, List<Target> targetList) {
        HashMap<String, Object> postData = new HashMap<String, Object>();
        PushResult pushResult = new PushResult();
        postData.put("action", "pushMessageToListAction");
        postData.put("appkey", this.appKey);
        postData.put("contentId", contentId);
        boolean needDetails = GTConfig.isPushListNeedDetails();
        postData.put("needDetails", needDetails);
        boolean async = GTConfig.isPushListAsync();
        postData.put("async", async);
        boolean needAliasDetails = GTConfig.isPushListNeedAliasDetails();
        postData.put("needAliasDetails", needAliasDetails);
        int limit = async && !needDetails ? GTConfig.getAsyncListLimit() : GTConfig.getSyncListLimit();
        if (targetList.size() > limit) {
            HashMap<String, String> response = new HashMap<String, String>();
            response.put("result", "target size:" + targetList.size() + " beyond the limit:" + limit);
            pushResult.setResponse(response);
            return pushResult;
        }
        ArrayList<String> clientIdList = new ArrayList<String>();
        ArrayList<String> aliasList = new ArrayList<String>();
        String appId = null;
        for (Target target : targetList) {
            String targetCid = target.getClientId();
            String targetAlias = target.getAlias();
            if (targetCid != null && !"".equals(targetCid.trim())) {
                clientIdList.add(targetCid);
            } else if (targetAlias != null && !"".equals(targetAlias.trim())) {
                aliasList.add(targetAlias);
            }
            if (appId != null && !"".equals(appId.trim())) continue;
            appId = target.getAppId();
        }
        postData.put("appId", appId);
        postData.put("clientIdList", clientIdList);
        postData.put("aliasList", aliasList);
        postData.put("type", 2);
        long start = System.currentTimeMillis();
        String url = PushDomainManager.getDomainUrl(this.domainKey);
        Map<String, Object> response = this.httpPostJSON(url, postData, true);
        pushResult.setResponse(response);
        long end = System.currentTimeMillis();
        OSDomainWrapper wrapper = PushDomainManager.domainMap.get(this.domainKey);
        wrapper.incrementListCount(url);
        wrapper.addListTime(url, end - start);
        return pushResult;
    }

    public IPushResult pushMessageToApp(AppMessage message) throws PushAppException {
        String contentId = this.getListAppContentId((Message)message, null);
        return this.pushMessageToApp(contentId);
    }

    public IPushResult pushMessageToApp(AppMessage message, String taskGroupName) throws PushAppException {
        String contentId = this.getListAppContentId((Message)message, taskGroupName);
        return this.pushMessageToApp(contentId);
    }

    public boolean stop(String contentId) {
        HashMap<String, Object> postData = new HashMap<String, Object>();
        postData.put("action", "stopTaskAction");
        postData.put("appkey", this.appKey);
        postData.put("contentId", contentId);
        Map<String, Object> response = this.httpPostJSON(postData);
        return "ok".equals(response.get("result"));
    }

    public IQueryResult getClientIdStatus(String appId, String clientId) {
        QueryResult result = new QueryResult();
        HashMap<String, Object> postData = new HashMap<String, Object>();
        postData.put("action", "getClientIdStatusAction");
        postData.put("appkey", this.appKey);
        postData.put("appId", appId);
        postData.put("clientId", clientId);
        Map<String, Object> response = this.httpPostJSON(postData);
        result.setResponse(response);
        return result;
    }

    public IQueryResult setClientTag(String appId, String clientId, List<String> tags) {
        QueryResult result = new QueryResult();
        HashMap<String, Object> postData = new HashMap<String, Object>();
        postData.put("action", "setTagAction");
        postData.put("appkey", this.appKey);
        postData.put("appId", appId);
        postData.put("clientId", clientId);
        postData.put("tagList", tags);
        Map<String, Object> response = this.httpPostJSON(postData);
        result.setResponse(response);
        return result;
    }

    private IQueryResult setBadge(String badge, String appid, List<String> deviceTokenList, List<String> cidList) {
        HashMap<String, Object> postData = new HashMap<String, Object>();
        postData.put("action", "setBadgeAction");
        postData.put("appkey", this.appKey);
        postData.put("badge", badge);
        postData.put("appid", appid);
        postData.put("deviceToken", deviceTokenList);
        postData.put("cid", cidList);
        Map<String, Object> response = this.httpPostJSON(postData);
        QueryResult result = new QueryResult();
        result.setResponse(response);
        return result;
    }

    public IQueryResult setBadgeForCID(String badge, String appid, List<String> cidList) {
        return this.setBadge(badge, appid, new ArrayList<String>(), cidList);
    }

    public IQueryResult setBadgeForDeviceToken(String badge, String appid, List<String> deviceTokenList) {
        return this.setBadge(badge, appid, deviceTokenList, new ArrayList<String>());
    }

    private IPushResult pushMessageToApp(String contentId) throws PushAppException {
        PushResult pushResult = new PushResult();
        HashMap<String, Object> postData = new HashMap<String, Object>();
        try {
            postData.put("action", "pushMessageToAppAction");
            postData.put("appkey", this.appKey);
            postData.put("contentId", contentId);
            postData.put("type", 2);
            long start = System.currentTimeMillis();
            String url = PushDomainManager.getDomainUrl(this.domainKey);
            Map<String, Object> response = this.httpPostJSON(url, postData);
            long end = System.currentTimeMillis();
            OSDomainWrapper wrapper = PushDomainManager.domainMap.get(this.domainKey);
            wrapper.incrementAppCount(url);
            wrapper.addAppTime(url, end - start);
            pushResult.setResponse(response);
            return pushResult;
        }
        catch (Exception e) {
            throw new PushAppException(contentId, (Throwable)e);
        }
    }

    private String getListAppContentId(Message message, String taskGroupName) {
        HashMap<String, Object> postData = new HashMap<String, Object>();
        Map<String, Object> response = null;
        if (taskGroupName != null) {
            postData.put("taskGroupName", taskGroupName);
        }
        postData.put("action", "getContentIdAction");
        postData.put("appkey", this.appKey);
        postData.put("clientData", Base64Util.getBASE64((byte[])message.getData().getTransparent().toByteArray()));
        postData.put("transmissionContent", message.getData().getTransmissionContent());
        postData.put("isOffline", message.isOffline());
        postData.put("offlineExpireTime", message.getOfflineExpireTime());
        postData.put("pushType", message.getData().getPushType());
        postData.put("type", 2);
        if (message instanceof ListMessage) {
            postData.put("contentType", 1);
        } else if (message instanceof AppMessage) {
            postData.put("contentType", 2);
            AppMessage appMessage = (AppMessage)message;
            ParamUtils.checkAppid(message, appMessage.getAppIdList());
            postData.put("appIdList", appMessage.getAppIdList());
            List phoneTypeList = null;
            List provinceList = null;
            List tagList = null;
            ArrayList personaTags = new ArrayList();
            if (appMessage.getConditions() == null) {
                phoneTypeList = appMessage.getPhoneTypeList();
                provinceList = appMessage.getProvinceList();
                tagList = appMessage.getTagList();
                postData.put("phoneTypeList", phoneTypeList);
                postData.put("provinceList", provinceList);
                postData.put("tagList", tagList);
            } else {
                List conditions = appMessage.getConditions().getCondition();
                postData.put("conditions", conditions);
            }
            postData.put("speed", appMessage.getSpeed());
            String pushTime = appMessage.getPushTime();
            if (pushTime != null && !pushTime.isEmpty()) {
                postData.put("pushTime", pushTime);
            }
        }
        postData.put("pushNetWorkType", message.getPushNetWorkType());
        this.validateStrategyJson(postData, message.getStrategyJson());
        response = this.httpPostJSON(postData);
        String result = LangUtil.parseString((Object)response.get("result"));
        String contentId = LangUtil.parseString((Object)response.get("contentId"));
        if ("ok".equals(result) && contentId != null) {
            return contentId;
        }
        throw new RuntimeException("host:[" + PushDomainManager.getDomainUrl(this.domainKey) + "]" + "\u83b7\u53d6contentId\u5931\u8d25:" + result);
    }

    public IBatch getBatch() {
        return new BatchImpl(this.appKey, this);
    }

    @Deprecated
    public IPushResult pushAPNMessageToSingle(String appId, String deviceToken, SingleMessage message) {
        PushResult pushResult = new PushResult();
        if (deviceToken == null || deviceToken.length() != 64) {
            throw new IllegalArgumentException("deviceToken[" + deviceToken + "] length must be 64");
        }
        HashMap<String, Object> postData = new HashMap<String, Object>();
        postData.put("action", "apnPushToSingleAction");
        postData.put("appId", appId);
        postData.put("appkey", this.appKey);
        postData.put("DT", deviceToken);
        postData.put("PI", Base64Util.getBASE64((byte[])message.getData().getPushInfo().toByteArray()));
        postData.put("isOffline", message.isOffline());
        postData.put("offlineExpireTime", message.getOfflineExpireTime());
        postData.put("pushNetWorkType", message.getPushNetWorkType());
        this.validateStrategyJson(postData, message.getStrategyJson());
        Map<String, Object> response = this.httpPostJSON(postData);
        pushResult.setResponse(response);
        return pushResult;
    }

    @Deprecated
    public IPushResult pushAPNMessageToList(String appId, String contentId, List<String> deviceTokenList) {
        HashMap<String, Object> postData = new HashMap<String, Object>();
        PushResult pushResult = new PushResult();
        for (String deviceToken : deviceTokenList) {
            if (deviceToken != null && deviceToken.length() == 64) continue;
            throw new IllegalArgumentException("deviceToken[" + deviceToken + "] length must be 64");
        }
        postData.put("action", "apnPushToListAction");
        postData.put("appkey", this.appKey);
        postData.put("appId", appId);
        postData.put("contentId", contentId);
        postData.put("DTL", deviceTokenList);
        postData.put("needDetails", GTConfig.isPushListNeedDetails());
        postData.put("async", GTConfig.isPushListAsync());
        Map<String, Object> response = this.httpPostJSON(postData);
        pushResult.setResponse(response);
        return pushResult;
    }

    @Deprecated
    public String getAPNContentId(String appId, ListMessage message) {
        HashMap<String, Object> postData = new HashMap<String, Object>();
        Map<String, Object> response = null;
        postData.put("action", "apnGetContentIdAction");
        postData.put("appkey", this.appKey);
        postData.put("appId", appId);
        postData.put("PI", Base64Util.getBASE64((byte[])message.getData().getPushInfo().toByteArray()));
        postData.put("isOffline", message.isOffline());
        postData.put("offlineExpireTime", message.getOfflineExpireTime());
        postData.put("pushNetWorkType", message.getPushNetWorkType());
        this.validateStrategyJson(postData, message.getStrategyJson());
        response = this.httpPostJSON(postData);
        String result = LangUtil.parseString((Object)response.get("result"));
        String contentId = LangUtil.parseString((Object)response.get("contentId"));
        if ("ok".equals(result) && contentId != null) {
            return contentId;
        }
        throw new RuntimeException("host:[" + PushDomainManager.getDomainUrl(this.domainKey) + "]" + "\u83b7\u53d6contentId\u5931\u8d25:" + result);
    }

    public IAliasResult bindAlias(String appId, String alias, String clientId) {
        HashMap<String, Object> postData = new HashMap<String, Object>();
        postData.put("action", "alias_bind");
        postData.put("appkey", this.appKey);
        postData.put("appid", appId);
        postData.put("alias", alias);
        postData.put("cid", clientId);
        Map<String, Object> response = this.httpPostJSON(postData);
        return AliasResultUtil.buidAliasResult(response);
    }

    public IAliasResult bindAlias(String appId, List<Target> targetList) {
        HashMap<String, Object> postData = new HashMap<String, Object>();
        ArrayList aliaslist = new ArrayList();
        for (Target target : targetList) {
            HashMap<String, String> user = new HashMap<String, String>();
            user.put("cid", target.getClientId());
            user.put("alias", target.getAlias());
            aliaslist.add(user);
        }
        postData.put("action", "alias_bind_list");
        postData.put("appkey", this.appKey);
        postData.put("appid", appId);
        postData.put("aliaslist", aliaslist);
        Map<String, Object> response = this.httpPostJSON(postData);
        return AliasResultUtil.buidAliasResult(response);
    }

    public IAliasResult queryClientId(String appId, String alias) {
        HashMap<String, Object> postData = new HashMap<String, Object>();
        postData.put("action", "alias_query");
        postData.put("appkey", this.appKey);
        postData.put("appid", appId);
        postData.put("alias", alias);
        Map<String, Object> response = this.httpPostJSON(postData);
        response.put("alias", alias);
        return AliasResultUtil.buidAliasResult(response);
    }

    public IAliasResult queryAlias(String appId, String clientId) {
        HashMap<String, Object> postData = new HashMap<String, Object>();
        postData.put("action", "alias_query");
        postData.put("appkey", this.appKey);
        postData.put("appid", appId);
        postData.put("cid", clientId);
        Map<String, Object> response = this.httpPostJSON(postData);
        return AliasResultUtil.buidAliasResult(response);
    }

    public IAliasResult unBindAlias(String appId, String alias, String clientId) {
        HashMap<String, Object> postData = new HashMap<String, Object>();
        postData.put("action", "alias_unbind");
        postData.put("appkey", this.appKey);
        postData.put("appid", appId);
        postData.put("alias", alias);
        if (clientId != null && clientId.trim().length() > 0) {
            postData.put("cid", clientId);
        }
        Map<String, Object> response = this.httpPostJSON(postData);
        return AliasResultUtil.buidAliasResult(response);
    }

    public IAliasResult unBindAliasAll(String appId, String alias) {
        return this.unBindAlias(appId, alias, null);
    }

    public IPushResult getPushResult(String taskId) {
        HashMap<String, Object> postData = new HashMap<String, Object>();
        PushResult pushResult = new PushResult();
        postData.put("action", "getPushMsgResult");
        postData.put("appkey", this.appKey);
        postData.put("taskId", taskId);
        Map<String, Object> response = this.httpPostJSON(postData);
        pushResult.setResponse(response);
        return pushResult;
    }

    public IQueryResult getPushResultByGroupName(String appId, String groupName) {
        HashMap<String, Object> postData = new HashMap<String, Object>();
        QueryResult queryResult = new QueryResult();
        postData.put("action", "getPushResultByGroupName");
        postData.put("appkey", this.appKey);
        postData.put("appId", appId);
        postData.put("groupName", groupName);
        Map<String, Object> response = this.httpPostJSON(postData);
        queryResult.setResponse(response);
        return queryResult;
    }

    public IQueryResult getLast24HoursOnlineUserStatistics(String appId) {
        HashMap<String, Object> postData = new HashMap<String, Object>();
        QueryResult queryResult = new QueryResult();
        postData.put("action", "getLast24HoursOnlineUser");
        postData.put("appkey", this.appKey);
        postData.put("appId", appId);
        Map<String, Object> response = this.httpPostJSON(postData);
        queryResult.setResponse(response);
        return queryResult;
    }

    public IPushResult getUserTags(String appId, String clientId) {
        HashMap<String, Object> postData = new HashMap<String, Object>();
        PushResult pushResult = new PushResult();
        postData.put("action", "getUserTags");
        postData.put("appkey", this.appKey);
        postData.put("appId", appId);
        postData.put("clientId", clientId);
        Map<String, Object> response = this.httpPostJSON(postData);
        pushResult.setResponse(response);
        return pushResult;
    }

    public IPushResult getUserListTags(String appId, List<String> cidList) {
        HashMap<String, Object> postData = new HashMap<String, Object>();
        postData.put("action", "getUserListTags");
        postData.put("appkey", this.appKey);
        postData.put("appId", appId);
        postData.put("clientIds", cidList);
        return new PushResult(this.httpPostJSON(postData));
    }

    public IQueryResult queryAppPushDataByDate(String appId, String date) {
        if (!LangUtil.validateDate((String)date)) {
            throw new IllegalArgumentException("DateError|" + date);
        }
        HashMap<String, Object> postData = new HashMap<String, Object>();
        QueryResult pushResult = new QueryResult();
        postData.put("action", "queryAppPushData");
        postData.put("appkey", this.appKey);
        postData.put("appId", appId);
        postData.put("date", date);
        Map<String, Object> response = this.httpPostJSON(postData);
        pushResult.setResponse(response);
        return pushResult;
    }

    public IQueryResult queryAppUserDataByDate(String appId, String date) {
        if (!LangUtil.validateDate((String)date)) {
            throw new IllegalArgumentException("DateError|" + date);
        }
        HashMap<String, Object> postData = new HashMap<String, Object>();
        QueryResult pushResult = new QueryResult();
        postData.put("action", "queryAppUserData");
        postData.put("appkey", this.appKey);
        postData.put("appId", appId);
        postData.put("date", date);
        Map<String, Object> response = this.httpPostJSON(postData);
        pushResult.setResponse(response);
        return pushResult;
    }

    public IQueryResult getPersonaTags(String appId) {
        HashMap<String, Object> postData = new HashMap<String, Object>();
        QueryResult pushResult = new QueryResult();
        postData.put("action", "getPersonaTags");
        postData.put("appId", appId);
        postData.put("appkey", this.appKey);
        Map<String, Object> response = this.httpPostJSON(postData);
        pushResult.setResponse(response);
        return pushResult;
    }

    public IQueryResult queryUserCount(String appId, AppConditions conditions) {
        HashMap<String, Object> postData = new HashMap<String, Object>();
        QueryResult pushResult = new QueryResult();
        postData.put("action", "queryUserCount");
        postData.put("appId", appId);
        postData.put("appkey", this.appKey);
        if (conditions != null) {
            postData.put("conditions", conditions.getCondition());
        }
        Map<String, Object> response = this.httpPostJSON(postData);
        pushResult.setResponse(response);
        return pushResult;
    }

    public IPushResult createGroup(String appId, String groupName) {
        PushResult pushResult = new PushResult();
        HashMap<String, Object> postData = new HashMap<String, Object>();
        postData.put("action", "createGroupAction");
        postData.put("appId", appId);
        postData.put("appkey", this.appKey);
        postData.put("groupName", groupName);
        Map<String, Object> response = this.httpPostJSON(postData);
        pushResult.setResponse(response);
        return pushResult;
    }

    public IPushResult updateGroup(String appId, String groupId, List<String> addCids, List<String> delCids) {
        PushResult pushResult = new PushResult();
        HashMap<String, Object> postData = new HashMap<String, Object>();
        postData.put("action", "updateGroupAction");
        postData.put("appId", appId);
        postData.put("appkey", this.appKey);
        postData.put("groupId", groupId);
        postData.put("addCids", addCids);
        postData.put("delCids", delCids);
        Map<String, Object> response = this.httpPostJSON(postData);
        pushResult.setResponse(response);
        return pushResult;
    }

    public IPushResult removeGroup(String appId, String groupId) {
        PushResult pushResult = new PushResult();
        HashMap<String, Object> postData = new HashMap<String, Object>();
        postData.put("action", "removeGroupAction");
        postData.put("appId", appId);
        postData.put("appkey", this.appKey);
        postData.put("groupId", groupId);
        Map<String, Object> response = this.httpPostJSON(postData);
        pushResult.setResponse(response);
        return pushResult;
    }

    public IPushResult pushMessageToGroup(String appId, GroupMessage gMessage) {
        PushResult pushResult = new PushResult();
        HashMap<String, Object> postData = new HashMap<String, Object>();
        postData.put("action", "pushMessageToGroupAction");
        postData.put("appkey", this.appKey);
        if (gMessage.getRequestId() != null) {
            postData.put("requestId", gMessage.getRequestId());
        }
        postData.put("clientData", Base64Util.getBASE64((byte[])gMessage.getData().getTransparent().toByteArray()));
        postData.put("transmissionContent", gMessage.getData().getTransmissionContent());
        postData.put("appId", appId);
        postData.put("groupId", gMessage.getGroupId());
        Map<String, Object> response = this.httpPostJSON(postData);
        pushResult.setResponse(response);
        return pushResult;
    }

    public IPushResult queryCidStatusByGroupid(String appId, String groupId, List<String> cids) {
        PushResult pushResult = new PushResult();
        HashMap<String, Object> postData = new HashMap<String, Object>();
        postData.put("action", "queryCidStatusByGroupidAction");
        postData.put("appId", appId);
        postData.put("appkey", this.appKey);
        postData.put("groupId", groupId);
        postData.put("cids", cids);
        Map<String, Object> response = this.httpPostJSON(postData);
        pushResult.setResponse(response);
        return pushResult;
    }

    public IPushResult queryCidsByGroupid(String appId, String groupId) {
        PushResult pushResult = new PushResult();
        HashMap<String, Object> postData = new HashMap<String, Object>();
        postData.put("action", "queryCidsByGroupidAction");
        postData.put("appId", appId);
        postData.put("appkey", this.appKey);
        postData.put("groupId", groupId);
        Map<String, Object> response = this.httpPostJSON(postData);
        pushResult.setResponse(response);
        return pushResult;
    }

    public IPushResult getPushResultByTaskidList(List<String> taskIdList) {
        return this.getPushActionResultByTaskids(taskIdList, null);
    }

    public IPushResult getPushActionResultByTaskids(List<String> taskIdList, List<String> actionIdList) {
        HashMap<String, Object> postData = new HashMap<String, Object>();
        PushResult pushResult = new PushResult();
        postData.put("action", "getPushMsgResultByTaskidList");
        postData.put("appkey", this.appKey);
        postData.put("taskIdList", taskIdList);
        postData.put("actionIdList", actionIdList);
        Map<String, Object> response = this.httpPostJSON(postData);
        pushResult.setResponse(response);
        return pushResult;
    }

    public IQueryResult changeClientTag(String appId, String tag, byte operation, List<String> cids) {
        QueryResult result = new QueryResult();
        HashMap<String, Object> postData = new HashMap<String, Object>();
        postData.put("action", "changeTagAction");
        postData.put("appkey", this.appKey);
        postData.put("appId", appId);
        postData.put("operation", operation);
        postData.put("tag", tag);
        postData.put("cids", cids);
        Map<String, Object> response = this.httpPostJSON(postData);
        result.setResponse(response);
        return result;
    }

    public IPushResult pushTagMessage(TagMessage message, String requestId) {
        if (requestId == null || "".equals(requestId.trim())) {
            requestId = UUID.randomUUID().toString();
        }
        HashMap<String, Object> postData = new HashMap<String, Object>();
        postData.put("action", "pushMessageByTagAction");
        postData.put("appkey", this.appKey);
        postData.put("clientData", Base64Util.getBASE64((byte[])message.getData().getTransparent().toByteArray()));
        postData.put("transmissionContent", message.getData().getTransmissionContent());
        postData.put("isOffline", message.isOffline());
        postData.put("offlineExpireTime", message.getOfflineExpireTime());
        postData.put("pushNetWorkType", message.getPushNetWorkType());
        postData.put("appIdList", message.getAppIdList());
        postData.put("speed", message.getSpeed());
        postData.put("requestId", requestId);
        postData.put("tag", message.getTag());
        this.validateStrategyJson(postData, message.getStrategyJson());
        PushResult pushResult = new PushResult();
        Map<String, Object> response = this.httpPostJSON(postData);
        pushResult.setResponse(response);
        return pushResult;
    }

    public IPushResult pushTagMessage(TagMessage message) {
        return this.pushTagMessage(message, null);
    }

    public IPushResult getScheduleTask(String taskId, String appId) {
        PushResult pushResult = new PushResult();
        HashMap<String, Object> postData = new HashMap<String, Object>();
        postData.put("action", "getScheduleTaskAction");
        postData.put("appId", appId);
        postData.put("appkey", this.appKey);
        postData.put("taskId", taskId);
        Map<String, Object> response = this.httpPostJSON(postData);
        pushResult.setResponse(response);
        return pushResult;
    }

    public IPushResult delScheduleTask(String taskId, String appId) {
        PushResult pushResult = new PushResult();
        HashMap<String, Object> postData = new HashMap<String, Object>();
        postData.put("action", "delScheduleTaskAction");
        postData.put("appId", appId);
        postData.put("appkey", this.appKey);
        postData.put("taskId", taskId);
        Map<String, Object> response = this.httpPostJSON(postData);
        pushResult.setResponse(response);
        return pushResult;
    }

    public IPushResult bindCidPn(String appId, Map<String, String> cidAndPn) {
        PushResult pushResult = new PushResult();
        HashMap<String, Object> postData = new HashMap<String, Object>();
        postData.put("action", "bind_cid_pn");
        postData.put("appId", appId);
        postData.put("appkey", this.appKey);
        postData.put("cidpnlist", cidAndPn);
        Map<String, Object> response = this.httpPostJSON(postData);
        pushResult.setResponse(response);
        return pushResult;
    }

    public IPushResult unbindCidPn(String appId, List<String> cid) {
        PushResult pushResult = new PushResult();
        HashMap<String, Object> postData = new HashMap<String, Object>();
        postData.put("action", "unbind_cid_pn");
        postData.put("appId", appId);
        postData.put("appkey", this.appKey);
        postData.put("cids", cid);
        Map<String, Object> response = this.httpPostJSON(postData);
        pushResult.setResponse(response);
        return pushResult;
    }

    public IPushResult queryCidPn(String appId, List<String> cid) {
        PushResult pushResult = new PushResult();
        HashMap<String, Object> postData = new HashMap<String, Object>();
        postData.put("action", "query_cid_pn");
        postData.put("appId", appId);
        postData.put("appkey", this.appKey);
        postData.put("cids", cid);
        Map<String, Object> response = this.httpPostJSON(postData);
        pushResult.setResponse(response);
        return pushResult;
    }

    public IPushResult stopSendSms(String appId, String taskId) {
        PushResult pushResult = new PushResult();
        HashMap<String, Object> postData = new HashMap<String, Object>();
        postData.put("action", "stop_sms");
        postData.put("appId", appId);
        postData.put("appkey", this.appKey);
        postData.put("taskId", taskId);
        Map<String, Object> response = this.httpPostJSON(postData);
        pushResult.setResponse(response);
        return pushResult;
    }

    public String getAuthToken() {
        return this.authToken;
    }

    public String getMasterSecret() {
        return this.masterSecret;
    }

    public void setMasterSecret(String masterSecret) {
        this.masterSecret = masterSecret;
    }
}

