/*
 * Decompiled with CFR 0.152.
 */
package com.gexin.rp.sdk.http;

import com.gexin.fastjson.JSON;
import com.gexin.rp.sdk.base.IBatch;
import com.gexin.rp.sdk.base.IPushResult;
import com.gexin.rp.sdk.base.impl.PushResult;
import com.gexin.rp.sdk.base.impl.SingleMessage;
import com.gexin.rp.sdk.base.impl.Target;
import com.gexin.rp.sdk.base.uitls.Base64Util;
import com.gexin.rp.sdk.dto.GtReq;
import com.gexin.rp.sdk.http.GtPush;
import com.gexin.rp.sdk.http.utils.GTConfig;
import com.gexin.rp.sdk.http.utils.OSDomainWrapper;
import com.gexin.rp.sdk.http.utils.PushDomainManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;

public class BatchImpl
implements IBatch {
    private String batchId;
    private List<GtReq.SingleBatchItem> innerMsgList = new ArrayList<GtReq.SingleBatchItem>();
    private AtomicInteger seqId = new AtomicInteger();
    private String APPKEY;
    private GtPush push;
    private Map<String, Object> lastPostData = new HashMap<String, Object>();

    public BatchImpl(String appKey, GtPush push) {
        this.batchId = UUID.randomUUID().toString();
        this.APPKEY = appKey;
        this.push = push;
    }

    public String getBatchId() {
        return this.batchId;
    }

    public String add(SingleMessage message, Target target) throws Exception {
        if (this.seqId.incrementAndGet() > 5000) {
            this.seqId.decrementAndGet();
            throw new Exception("Can not add over 5000 message once! Please call submit() first.");
        }
        String json = this.createPostParams(message, target);
        GtReq.SingleBatchItem item = GtReq.SingleBatchItem.newBuilder().setSeqId(this.seqId.get()).setData(json).build();
        this.innerMsgList.add(item);
        return this.seqId.get() + "";
    }

    public String add(SingleMessage message, Target target, String requestId) throws Exception {
        if (this.seqId.incrementAndGet() > 5000) {
            this.seqId.decrementAndGet();
            throw new Exception("Can not add over 5000 message once! Please call submit() first.");
        }
        String json = this.createPostParams(message, target, requestId);
        GtReq.SingleBatchItem item = GtReq.SingleBatchItem.newBuilder().setSeqId(this.seqId.get()).setData(json).build();
        this.innerMsgList.add(item);
        return this.seqId.get() + "";
    }

    public String createPostParams(SingleMessage message, Target target) throws Exception {
        Map<String, Object> postData = this.push.getSingleMessagePostData(message, target, null);
        String jsonData = JSON.toJSONString(postData);
        return jsonData;
    }

    public String createPostParams(SingleMessage message, Target target, String requestId) throws Exception {
        Map<String, Object> postData = this.push.getSingleMessagePostData(message, target, requestId);
        String jsonData = JSON.toJSONString(postData);
        return jsonData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPushResult submit() throws IOException {
        String requestId = UUID.randomUUID().toString();
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("appkey", this.APPKEY);
        data.put("action", "pushMessageToSingleBatchAction");
        data.put("serialize", "pb");
        data.put("async", GTConfig.isPushSingleBatchAsync());
        data.put("requestId", requestId);
        GtReq.SingleBatchRequest body = GtReq.SingleBatchRequest.newBuilder().setBatchId(this.batchId).addAllBatchItem(this.innerMsgList).build();
        data.put("singleDatas", Base64Util.getBASE64((byte[])body.toByteArray()));
        try {
            long start = System.currentTimeMillis();
            String url = PushDomainManager.getDomainUrl(this.push.getDomainKey());
            Map<String, Object> retMap = this.push.httpPostJSON(url, data, true);
            long end = System.currentTimeMillis();
            OSDomainWrapper wrapper = PushDomainManager.domainMap.get(this.push.getDomainKey());
            wrapper.incrementAppCount(url);
            wrapper.addAppTime(url, end - start);
            PushResult pr = new PushResult();
            pr.setResponse(retMap);
            PushResult pushResult = pr;
            return pushResult;
        }
        finally {
            this.seqId.set(0);
            this.innerMsgList.clear();
            this.lastPostData = data;
        }
    }

    public IPushResult retry() throws IOException {
        Map<String, Object> retMap = this.push.httpPostJSON(this.lastPostData, true);
        PushResult pr = new PushResult();
        pr.setResponse(retMap);
        return pr;
    }

    @Deprecated
    public void setApiUrl(String apiUrl) {
    }
}

