package com.fshows.ysepay.response.income;

import com.fshows.sdk.core.client.base.definition.IResponseDefinition;
import lombok.Data;

/**
 * 查询授权信息响应对象
 */
@Data
public class YsepayIncomeQueryAuthInfoResponse implements IResponseDefinition {
    
    private static final long serialVersionUID = -1332004613775622034L;
    /**
     * 商户号(成功时才有值)
     * 字节长度: String(20)
     */
    private String mercId;

    /**
     * 权限流水号
     * 字节长度: String(32)
     */
    private String authId;

    /**
     * 状态
     * 00-成功
     * 01-初始化
     * 02-签约中(电子合同才会出现此状态)
     * 03-待审核(纸质合同或发起方不支持自动审核会出现此状态)
     * 04-审核拒绝
     * 字节长度: String(2)
     */
    private String status;

    /**
     * 签约流水号(电子合同才有值)
     * 字节长度: String(20)
     */
    private String signId;

    /**
     * 备注(审核拒绝才有值)
     * 字节长度: String(400)
     */
    private String note;

    /**
     * 业务方权限id
     * 字节长度: String(32)
     */
    private String thirdAuthId;
} 