package com.fshows.ysepay.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.security.MessageDigest;

import org.apache.commons.codec.binary.Hex;

public class FileUtil {
    
    /**
     * 读取文件内容为字节数组
     */
    public static byte[] readFileToBytes(File file) throws IOException {
        return Files.readAllBytes(file.toPath());
    }
    
    /**
     * 计算文件的SHA256值
     */
    public static String calculateSHA256(byte[] content) throws Exception {
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        byte[] hash = digest.digest(content);
        return Hex.encodeHexString(hash);
    }
    
    /**
     * 验证文件格式
     */
    public static boolean isValidImageFormat(String fileName) {
        String ext = fileName.toLowerCase();
        return ext.endsWith(".jpg") || ext.endsWith(".jpeg") 
            || ext.endsWith(".png") || ext.endsWith(".bmp");
    }
    
    /**
     * 验证文件大小
     */
    public static boolean isValidFileSize(byte[] content) {
        return content.length <= 2 * 1024 * 1024; // 2MB
    }
} 