package com.fshows.ysepay.response.income;

import com.fshows.sdk.core.client.base.definition.IResponseDefinition;
import lombok.Data;

/**
 * 商户进件状态查询响应对象
 */
@Data
public class YsepayQueryCustChangeResponse implements IResponseDefinition {
    
    private static final long serialVersionUID = -6371062095122465173L;
    /**
     * 变更流水
     * 字节长度: String(21)
     */
    private String changeSysFlowId;

    /**
     * 状态
     * 00:成功 01:待上传图片 02:待审核 03-待签署电子变更申请表 90:审核拒绝 99:失败
     * 字节长度: String(2)
     */
    private String status;

    /**
     * 客户号
     * 字节长度: String(20)
     */
    private String custId;

    /**
     * 备注
     */
    private String note;

    /**
     * 签约id
     * status=03且成功时返回
     * 字节长度: String(20)
     */
    private String signId;

    /**
     * 签约地址
     * status=03且成功时返回
     * 字节长度: String(50)
     */
    private String signUrl;

    /**
     * 业务方变更申请流水号
     * 字节长度: String(32)
     */
    private String changeThirdFlowId;
} 