package com.fshows.ysepay.response;

import java.math.BigDecimal;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 银盛支付微信C扫B支付响应对象
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class YsepayWeixinPayResponse extends YsepayBizResponse {
    

    /**
     * 商户系统生成的订单号
     * 字节长度: String(32)
     * 必填: 是
     * 示例值: 6843192280647118
     */
    private String outTradeNo;

    /**
     * 银盛支付交易流水号
     * 字节长度: String(30)
     * 必填: 否
     */
    private String tradeNo;

    /**
     * 交易状态
     * 成功状态的值为: TRADE_SUCCESS
     * 字节长度: String
     * 必填: 是
     */
    private String tradeStatus;

    /**
     * 订单金额
     * 该笔订单的资金总额，单位为RMB-Yuan
     * 取值范围为[0.01，100000000.00]，精确到小数点后两位
     * 字节长度: Number
     * 必填: 是
     * 示例值: 100
     */
    private BigDecimal totalAmount;

    /**
     * 交易币种
     * 字节长度: String(3)
     * 必填: 否
     * 默认CNY
     */
    private String currency;

    /**
     * 公用回传参数
     * 商户自定义数据域，原样返回
     * 字节长度: String(2000)
     * 必填: 否
     */
    private String extraCommonParam;

    /**
     * Json格式字符串，作用于原生态的js支付时的参数
     * 字节长度: String
     * 必填: 是
     */
    private String jsapiPayInfo;

    /**
     * 是否参与优惠
     * Y表示参与，N表示不参与
     * 字节长度: String
     * 必填: 否
     */
    private String isDiscount;

    /**
     * 参考总优惠金额
     * 字节长度: Double
     * 必填: 否
     * 示例值: 100.00
     */
    private BigDecimal totalDiscount;

    /**
     * 发往渠道流水号
     * 字节长度: String(50)
     * 必填: 否
     */
    private String channelSendSn;

    /**
     * JSAPI支付信息
     */
    @Data
    public static class JsapiPayInfo {
        /**
         * 商户在微信侧申请的APPID
         * 字节长度: String[1,32]
         * 必填: 是
         * 示例值: wxd678efh567hg6787
         */
        private String appId;

        /**
         * 时间戳
         * 字节长度: String[1,32]
         * 必填: 是
         */
        private String timeStamp;

        /**
         * 随机字符串
         * 字节长度: String[1,32]
         * 必填: 是
         * 示例值: 5K8264ILTKCH16CQ2502SI8
         */
        private String nonceStr;

        /**
         * 订单详情扩展字符串
         * 字节长度: String[1,128]
         * 必填: 是
         * 示例值: prepay_id=u802345jgfjsdfg
         */
        private String packageValue;

        /**
         * 签名方式
         * 字节长度: String[1,32]
         * 必填: 是
         * 示例值: MD5
         */
        private String signType;

        /**
         * 签名
         * 字节长度: String[1,256]
         * 必填: 是
         * 示例值: C380BEC2BFD727A4B6845132
         */
        private String paySign;
    }
} 