package com.fshows.ysepay.response;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 银盛支付-对账文件下载响应对象
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class YsepayUnionaccountDownloadUrlGetResponse extends YsepayBizResponse {

    /**
     * 状态
     * SUCCESS 对账单生成成功
     * FAILURE 对账单生成失败
     * PROCESSING 对账单文件正在生成中，请稍后重试
     * NO_CONTEXT 对账单内容为空
     * 字节长度: String
     * 必填: 是
     */
    private String state;

    /**
     * 描述
     * 字节长度: String
     * 必填: 是
     */
    private String desc;

    /**
     * 文件下载地址
     * 字节长度: String
     * 必填: 否
     */
    private String billDownloadUrl;
} 