package com.fshows.ysepay.response;

import java.math.BigDecimal;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 银盛退款响应对象
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class YsepayTradeRefundResponse extends YsepayBizResponse {
    
    /**
     * 本次发生的退款金额
     * 字节长度: Number
     * 必填: 是
     * 示例值: 88.89
     */
    private BigDecimal refundAmount;

    /**
     * 银盛支付平台的订单交易流水
     * 字节长度: String(1,30)
     * 必填: 是
     * 示例值: 311160414497667096
     */
    private String tradeNo;

    /**
     * 订单支付时传入的商户订单号
     * 字节长度: String(1,32)
     * 必填: 是
     * 示例值: 68431922806471166
     */
    private String outTradeNo;

    /**
     * 退款会计日期
     * 格式"yyyy-MM-dd"
     * 字节长度: String(10)
     * 必填: 是
     * 示例值: 2014-07-24
     */
    private String accountDate;

    /**
     * 商户退款请求单号
     * 字节长度: String(1,32)
     * 必填: 是
     * 示例值: RD2012061713107
     */
    private String outRequestNo;

    /**
     * 银盛退款流水号
     * 字节长度: String(1,32)
     * 必填: 是
     * 示例值: 01R210622215530564
     */
    private String refundsn;
} 