package com.fshows.ysepay.response;

import java.math.BigDecimal;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 银联行业码支付响应对象
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class YsepayCupmulappQrcodePayResponse extends YsepayBizResponse {
    

    /**
     * 商户系统内部订单号
     * 字节长度: String(32)
     * 必填: 是
     */
    private String outTradeNo;

    /**
     * 银盛支付交易流水号
     * 字节长度: String(30)
     * 必填: 否
     */
    private String tradeNo;

    /**
     * 交易状态
     * 成功状态的值: TRADE_SUCCESS
     * 字节长度: String
     * 必填: 是
     */
    private String tradeStatus;

    /**
     * 订单金额
     * 该笔订单的资金总额，单位为RMB-Yuan
     * 取值范围为[0.01，100000000.00]，精确到小数点后两位
     * 字节长度: Number
     * 必填: 是
     */
    private BigDecimal totalAmount;

    /**
     * 币种
     * 字节长度: String(3)
     * 必填: 否
     * 默认CNY
     */
    private String currency;

    /**
     * 支付链接
     * web_url为拉起支付收银台的中间页面，可通过访问该url来拉起客户端，完成支付
     * web_url的有效期为5分钟
     * 字节长度: String(300)
     * 必填: 是
     */
    private String webUrl;

    /**
     * 入账日期
     * 格式"yyyyMMdd"
     * 字节长度: String(10)
     * 必填: 否
     */
    private String accountDate;

    /**
     * 付款方手续费
     * 该笔订单的付款方手续费(参考)，单位为RMB-Yuan
     * 取值范围为[0.01，100000000.00]，精确到小数点后两位
     * 字节长度: Number
     * 必填: 否
     */
    private BigDecimal payerFee;

    /**
     * 收款方手续费
     * 该笔订单的收款方手续费(参考)，单位为RMB-Yuan
     * 取值范围为[0.01，100000000.00]，精确到小数点后两位
     * 字节长度: Number
     * 必填: 否
     */
    private BigDecimal payeeFee;

    /**
     * 合作方手续费
     * 该笔订单的合作方手续费(参考)，单位为RMB-Yuan
     * 取值范围为[0.01，100000000.00]，精确到小数点后两位
     * 字节长度: Number
     * 必填: 否
     */
    private BigDecimal partnerFee;

    /**
     * 手续费总和
     * 该笔订单的手续费总和(参考)，单位为RMB-Yuan
     * 取值范围为[0.01，100000000.00]，精确到小数点后两位
     * 字节长度: Number
     * 必填: 否
     */
    private BigDecimal fee;

    /**
     * 发往渠道流水号
     * 字节长度: String(50)
     * 必填: 否
     */
    private String channelSendSn;

    /**
     * 支付网关编号
     * 字节长度: String(16)
     * 必填: 否
     */
    private String paygateNo;

    /**
     * 渠道返回流水号
     * 字节长度: String(50)
     * 必填: 否
     */
    private String channelRecvSn;

    /**
     * 卡类型
     * credit:信用卡
     * debit:借记卡
     * 字节长度: String
     * 必填: 否
     */
    private String cardType;

    /**
     * 银联云闪付款方账号
     * 字节长度: String
     * 必填: 否
     */
    private String payerBankAccountNo;

    /**
     * 商户自定义数据域
     * 原样返回
     * 字节长度: String(2000)
     * 必填: 否
     */
    private String extraCommonParam;

    /**
     * 银联营销渠道响应优惠信息
     * JSON字符串
     * version小于3.6版本为List的JSON字符串
     * 3.6版本（含）以上为CouponInfo的JSON字符串
     * 字节长度: String(4000)
     * 必填: 否
     */
    private String couponInfo;

    /**
     * 营销优惠金额
     * 版本3.9及以上支持
     * 字节长度: Number
     * 必填: 否
     */
    private BigDecimal preferentialAmount;

    /**
     * 营销优惠手续费
     * 版本3.9及以上支持
     * 字节长度: Number
     * 必填: 否
     */
    private BigDecimal preferentialFee;

    /**
     * 营销规则信息json
     * 版本3.9及以上支持
     * 字节长度: String
     * 必填: 否
     */
    private String marketingRuleJson;
} 