/*
 * 51qbiz.com
 * Copyright (C) 2014-2025 All Rights Reserved.
 */
package com.fshows.ysepay.response;

import com.fshows.sdk.core.client.base.definition.IResponseDefinition;
import lombok.Data;

import java.io.Serializable;

/**
 * @author zhouyok * @version YsepayBizResponse.java, v 0.1 2025-05-16 下午6:10 zhouyok
 */
@Data
public class YsepayBizResponse implements IResponseDefinition {
	private static final long serialVersionUID = -6214503467353468641L;
	/**
	 * 响应代码
	 * 字节长度: String
	 * 必填: 是
	 */
	private String code;
	
	/**
	 * 响应代码描述
	 * 字节长度: String
	 * 必填: 是
	 */
	private String msg;
	
	/**
	 * 错误码
	 * 字节长度: String(50)
	 * 必填: 否
	 */
	private String subCode;
	
	/**
	 * 错误码描述
	 * 字节长度: String
	 * 必填: 否
	 */
	private String subMsg;
}