/**
 * fshows.com
 * Copyright (C) 2013-2025 All Rights Reserved.
 */
package com.fshows.ysepay.request.trade.item;

import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author wangyi
 * @version WxDetailRequest.java, v 0.1 2025-06-03 15:12 wangyi
 */
@Data
public class YsepayWxDetailRequest {

    /**
     * 订单原价，整数不超过14位，小数不 超过2位，单位元 10．50
     */
    private BigDecimal costPrice;

    /**
     * 商品小票ID，长度不能超过32位 Ys001001
     */
    private String receiptId;

    /**
     * 订单优惠标记，代金券或立减优惠功能的参数
     */
    private String goodsTag;

    /**
     * 商品列表
     */
    private List<Goods> goodsDetail;

    /**
     * 微信单品优惠活动
     */
    @Data
    public static class Goods {

        /**
         * 商户商品编码,由半角的大小写字母，数字，下划线，中划线中的一种或者几种组成，长度不能超过32位 Shouji_abcef_001-001
         */
        private String goodsId;

        /**
         * 微信支付定义的统一商品编号，长度不能超过32 ,1001
         */
        private String wxpayGoodsId;

        /**
         * 商品的实际名称，长度不能超过256
         */
        private String goodsName;

        /**
         * 数量，只能是正整数 ,1000
         */
        private String quantity;

        /**
         * 商品单价，单位元，整数部分不能超过12位，小数不能超过2位 , 100.20
         */
        private BigDecimal price;
    }
}