package com.fshows.ysepay.request.terminal;

import java.util.List;

import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;

import com.fshows.ysepay.model.terminal.TerminalInfo;
import com.fshows.ysepay.request.YsepayBizRequest;

import com.fshows.ysepay.request.income.YsepayIncomeBizRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 终端报备请求对象
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class YsepayTerminalReportRequest extends YsepayIncomeBizRequest {
    
    private static final long serialVersionUID = 6818716624061629355L;
    /**
     * 终端列表
     * 必填: 是
     */
    @NotEmpty(message = "终端列表不能为空")
    @Valid
    private List<TerminalInfo> terminalInfoList;
} 