package com.fshows.ysepay.request.report;

import javax.validation.constraints.NotBlank;

import com.fshows.ysepay.request.YsepayBizRequest;

import com.fshows.ysepay.request.income.YsepayIncomeBizRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 查询报备信息请求对象
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class YsepayReportQueryInfoRequest extends YsepayIncomeBizRequest {
    
    private static final long serialVersionUID = -4935880881157615194L;
    /**
     * 商户号
     * 必填: 是
     */
    @NotBlank
    private String mercId;

    /**
     * 交易报备渠道编号
     * CUPS_WECHAT-银联微信
     * CUPS_ALIPAY-银联支付宝
     * NUCC_WECHAT-网联微信
     * NUCC_ALIPAY-网联支付宝
     * 必填: 是
     */
    @NotBlank
    private String channelId;
} 